using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using GroupLab.Networking;

namespace notifications
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private GroupLab.Networking.SharedDictionary sd;
		private System.ComponentModel.IContainer components;
		private GroupLab.Networking.Subscription sub1;
		private string URL = "tcp://localhost:webnotif";
		private System.Windows.Forms.TrackBar tbAnimateSpeed;
		public int AnimationSpeed = 2000;
		private System.Windows.Forms.Label labelAnimationSpeed;
		private string itemKey = "/items/?";			//This will be a notification:  the '?' 
													    // matches a unique GUID per notification
		

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			fit_scrollbar ();

			System.Diagnostics.Debug.WriteLine ("Opening " + this.URL);
			this.sd.Url = this.URL; // connect the shared dictionary to some default server
			this.sd.Open(); // spawn a server or a client

			System.Diagnostics.Debug.WriteLine ("Subscribing to " + itemKey);
			this.sub1.BeginInit(); // signal begining of initialization for subscription1
			this.sub1.Pattern = itemKey; // register the pattern with the shared dictionary server
			this.sub1.EndInit(); // signal the end of initialization
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.sd = new GroupLab.Networking.SharedDictionary(this.components);
			this.sub1 = new GroupLab.Networking.Subscription(this.components);
			this.tbAnimateSpeed = new System.Windows.Forms.TrackBar();
			this.labelAnimationSpeed = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.sub1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbAnimateSpeed)).BeginInit();
			this.SuspendLayout();
			// 
			// sd
			// 
			this.sd.SynchronizingObject = this;
			this.sd.Opened += new System.EventHandler(this.sd_Opened);
			// 
			// sub1
			// 
			this.sub1.Dictionary = this.sd;
			this.sub1.Notified += new GroupLab.Networking.SubscriptionEventHandler(this.sub1_Notified);
			// 
			// tbAnimateSpeed
			// 
			this.tbAnimateSpeed.AutoSize = false;
			this.tbAnimateSpeed.Location = new System.Drawing.Point(136, 520);
			this.tbAnimateSpeed.Maximum = 5000;
			this.tbAnimateSpeed.Minimum = 50;
			this.tbAnimateSpeed.Name = "tbAnimateSpeed";
			this.tbAnimateSpeed.Size = new System.Drawing.Size(592, 40);
			this.tbAnimateSpeed.TabIndex = 1;
			this.tbAnimateSpeed.TickFrequency = 100;
			this.tbAnimateSpeed.TickStyle = System.Windows.Forms.TickStyle.TopLeft;
			this.tbAnimateSpeed.Value = 50;
			// 
			// labelAnimationSpeed
			// 
			this.labelAnimationSpeed.Font = new System.Drawing.Font("Verdana", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.labelAnimationSpeed.Location = new System.Drawing.Point(0, 520);
			this.labelAnimationSpeed.Name = "labelAnimationSpeed";
			this.labelAnimationSpeed.Size = new System.Drawing.Size(136, 40);
			this.labelAnimationSpeed.TabIndex = 3;
			this.labelAnimationSpeed.Text = "Playback speed";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.GrayText;
			this.ClientSize = new System.Drawing.Size(728, 558);
			this.Controls.Add(this.labelAnimationSpeed);
			this.Controls.Add(this.tbAnimateSpeed);
			this.IsMdiContainer = true;
			this.MinimumSize = new System.Drawing.Size(50, 20);
			this.Name = "Form1";
			this.Text = "Notifications";
			this.Resize += new System.EventHandler(this.Form1_Resize);
			this.Closed += new System.EventHandler(this.Form1_Closed);
			((System.ComponentModel.ISupportInitialize)(this.sub1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbAnimateSpeed)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void createItem (string path)
		{
			System.Windows.Forms.Form f = new Form ();
			f.MdiParent = this;
			f.MaximizeBox = false;
			f.MinimizeBox = false;
			//f.ControlBox = false;
			f.MinimumSize = new System.Drawing.Size (100,50);
			//f.MaximumSize = new System.Drawing.Size (250, 280);
			f.ControlBox = true;
			f.FormBorderStyle = FormBorderStyle.SizableToolWindow;
			//f.Size = f.MinimumSize;
			f.ShowInTaskbar = false;
			mediaitem m = new mediaitem (this.sd, path, tbAnimateSpeed);
			m.Dock = DockStyle.Fill;
			f.Controls.Add (m);
			f.Visible = false;
			//f.Show ();
		}

		private void sub1_Notified(object sender, GroupLab.Networking.SubscriptionEventArgs e)
		{
			if (e.Reason == SubscriptionNotification.Add) 
			{
				System.Diagnostics.Debug.WriteLine ("Adding Notification");
				createItem (e.Path);
			}
		}

		private void Form1_Closed(object sender, System.EventArgs e)
		{
			//sd.Close ();
		}

		private void Form1_Resize(object sender, System.EventArgs e)
		{
			fit_scrollbar ();
		}
		private void fit_scrollbar ()
		{
			this.labelAnimationSpeed.Left = 0;
			this.labelAnimationSpeed.Top = this.Height - (2* this.labelAnimationSpeed.Height) + 4;
			this.tbAnimateSpeed.Left = this.labelAnimationSpeed.Width;
			this.tbAnimateSpeed.Top = this.labelAnimationSpeed.Top;
			this.tbAnimateSpeed.Width = this.Width - this.labelAnimationSpeed.Width - 11;
		}

		private void sd_Opened(object sender, System.EventArgs e)
		{
			System.Diagnostics.Debug.WriteLine ("Dictionary Opened");
		}
	}
}
