using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace WebTracker
{
	/// <summary>
	/// Summary description for ImagePreviewForm.
	/// </summary>
	public class ImagePreviewForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button button1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public static DialogResult Show(Image image)
		{
			using(ImagePreviewForm f = new ImagePreviewForm(image))
			{
				return f.ShowDialog();
			}
		}

		public static DialogResult Show(IWin32Window owner, Image image)
		{
			using(ImagePreviewForm f = new ImagePreviewForm(image))
			{
				return f.ShowDialog(owner);
			}
		}

		private ImagePreviewForm(Image image)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			this.pictureBox1.Image = image;
			Size s = new Size(image.Width + 80, image.Height + 80 + 23 + 20);
			this.ClientSize = s;
			this.pictureBox1.Location = new Point(40, 40);
			this.button1.Location = new Point((s.Width - this.button1.Width) / 2, s.Height - 20 - 23);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// pictureBox1
			// 
			this.pictureBox1.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.pictureBox1.BackColor = System.Drawing.Color.Bisque;
			this.pictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pictureBox1.Location = new System.Drawing.Point(96, 111);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// button1
			// 
			this.button1.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.button1.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.button1.Location = new System.Drawing.Point(109, 232);
			this.button1.Name = "button1";
			this.button1.TabIndex = 1;
			this.button1.Text = "Close";
			// 
			// ImagePreviewForm
			// 
			this.AcceptButton = this.button1;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.Color.Thistle;
			this.CancelButton = this.button1;
			this.ClientSize = new System.Drawing.Size(292, 273);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.pictureBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "ImagePreviewForm";
			this.Text = "Preivew";
			this.ResumeLayout(false);

		}
		#endregion
	}
}
