using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace recorder
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Button btnConnect;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbFile;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox tbKey;
		private System.Windows.Forms.TextBox tbURL;
		private System.Windows.Forms.Label label2;
		private GroupLab.Networking.Subscription subKey;
		private GroupLab.Networking.SharedDictionary sd;
		private System.Windows.Forms.Button btnUpload;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		private System.Windows.Forms.Button btnBrowse;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.btnConnect = new System.Windows.Forms.Button();
			this.btnSave = new System.Windows.Forms.Button();
			this.label3 = new System.Windows.Forms.Label();
			this.tbFile = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.tbKey = new System.Windows.Forms.TextBox();
			this.tbURL = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.subKey = new GroupLab.Networking.Subscription(this.components);
			this.sd = new GroupLab.Networking.SharedDictionary(this.components);
			this.btnUpload = new System.Windows.Forms.Button();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.label4 = new System.Windows.Forms.Label();
			this.btnBrowse = new System.Windows.Forms.Button();
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			((System.ComponentModel.ISupportInitialize)(this.subKey)).BeginInit();
			this.SuspendLayout();
			// 
			// btnConnect
			// 
			this.btnConnect.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnConnect.Location = new System.Drawing.Point(40, 152);
			this.btnConnect.Name = "btnConnect";
			this.btnConnect.Size = new System.Drawing.Size(96, 24);
			this.btnConnect.TabIndex = 8;
			this.btnConnect.Text = "Connect";
			this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
			// 
			// btnSave
			// 
			this.btnSave.Enabled = false;
			this.btnSave.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnSave.Location = new System.Drawing.Point(144, 152);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(96, 24);
			this.btnSave.TabIndex = 7;
			this.btnSave.Text = "Save";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// label3
			// 
			this.label3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label3.Location = new System.Drawing.Point(16, 120);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(40, 24);
			this.label3.TabIndex = 5;
			this.label3.Text = "File";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbFile
			// 
			this.tbFile.Location = new System.Drawing.Point(64, 120);
			this.tbFile.Name = "tbFile";
			this.tbFile.Size = new System.Drawing.Size(176, 20);
			this.tbFile.TabIndex = 6;
			this.tbFile.Text = "dictionary.sd.bin";
			// 
			// label1
			// 
			this.label1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label1.Location = new System.Drawing.Point(16, 88);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 24);
			this.label1.TabIndex = 3;
			this.label1.Text = "Key";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbKey
			// 
			this.tbKey.Location = new System.Drawing.Point(64, 88);
			this.tbKey.Name = "tbKey";
			this.tbKey.Size = new System.Drawing.Size(280, 20);
			this.tbKey.TabIndex = 4;
			this.tbKey.Text = "/*";
			// 
			// tbURL
			// 
			this.tbURL.Location = new System.Drawing.Point(64, 56);
			this.tbURL.Name = "tbURL";
			this.tbURL.Size = new System.Drawing.Size(280, 20);
			this.tbURL.TabIndex = 2;
			this.tbURL.Text = "tcp://localhost:webnotif";
			// 
			// label2
			// 
			this.label2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(40, 24);
			this.label2.TabIndex = 1;
			this.label2.Text = "URL";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// subKey
			// 
			this.subKey.Dictionary = this.sd;
			// 
			// sd
			// 
			this.sd.SynchronizingObject = this;
			this.sd.Closed += new System.EventHandler(this.sd_Closed);
			this.sd.Disconnected += new GroupLab.Networking.DisconnectedEventHandler(this.sd_Disconnected);
			this.sd.Connected += new System.EventHandler(this.sd_Connected);
			this.sd.Opened += new System.EventHandler(this.sd_Opened);
			// 
			// btnUpload
			// 
			this.btnUpload.Enabled = false;
			this.btnUpload.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnUpload.Location = new System.Drawing.Point(248, 152);
			this.btnUpload.Name = "btnUpload";
			this.btnUpload.Size = new System.Drawing.Size(96, 23);
			this.btnUpload.TabIndex = 0;
			this.btnUpload.Text = "Upload";
			this.btnUpload.Click += new System.EventHandler(this.btnUpload_Click);
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 201);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(362, 22);
			this.statusBar1.TabIndex = 9;
			this.statusBar1.Text = "Not Connected";
			// 
			// label4
			// 
			this.label4.AutoSize = true;
			this.label4.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label4.Location = new System.Drawing.Point(16, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(265, 26);
			this.label4.TabIndex = 10;
			this.label4.Text = "Dictionary Save/Upload Tool";
			// 
			// btnBrowse
			// 
			this.btnBrowse.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnBrowse.Location = new System.Drawing.Point(248, 120);
			this.btnBrowse.Name = "btnBrowse";
			this.btnBrowse.Size = new System.Drawing.Size(96, 23);
			this.btnBrowse.TabIndex = 11;
			this.btnBrowse.Text = "Browse...";
			this.btnBrowse.Click += new System.EventHandler(this.btnBrowse_Click);
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.Filter = "Saved Shared Dictionaries|*.sd.bin|All Files (*.*)|*.*";
			this.saveFileDialog1.OverwritePrompt = false;
			this.saveFileDialog1.Title = "Browse for Dictionary File...";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.Color.WhiteSmoke;
			this.ClientSize = new System.Drawing.Size(362, 223);
			this.Controls.Add(this.btnBrowse);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.btnUpload);
			this.Controls.Add(this.btnConnect);
			this.Controls.Add(this.btnSave);
			this.Controls.Add(this.tbFile);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.tbKey);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.tbURL);
			this.Controls.Add(this.label2);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.Name = "Form1";
			this.Text = "Dictionary Save/Upload";
			((System.ComponentModel.ISupportInitialize)(this.subKey)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void btnConnect_Click(object sender, System.EventArgs e)
		{
			this.sd.Url = this.tbURL.Text; // connect the shared dictionary to some default server
			this.statusBar1.Text = string.Format("Connecting to... {0}", this.sd.Url);
			this.sd.Open(); // spawn a server or a client
			this.subKey.BeginInit(); // signal begining of initialization for subscription1
			this.subKey.Pattern = this.tbKey.Text; // register the pattern with the shared dictionary server
			this.subKey.EndInit(); // signal the end of initialization
		}

		private void sd_Opened(object sender, System.EventArgs e)
		{
			this.statusBar1.Text = string.Format("Fully connected to {0} and ready to save/upload...", this.sd.Url);
			this.btnSave.Enabled = true;
			this.btnUpload.Enabled = true;
		}

		private void sd_Closed(object sender, System.EventArgs e)
		{
			this.statusBar1.Text = "Not connected";
		}

		private void sd_Connected(object sender, System.EventArgs e)
		{
			this.statusBar1.Text = "Completing connection...";
		}

		private void sd_Disconnected(object sender, GroupLab.Networking.DisconnectedEventArgs e)
		{
			this.btnSave.Enabled = false;
			this.btnUpload.Enabled = false;
			GroupLab.Networking.Troubleshooter.Show(this, this.sd, e);
		}

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			try
			{
				GroupLab.Networking.ComAwareBinaryFormatter bf = new GroupLab.Networking.ComAwareBinaryFormatter();
				ArrayList al = new ArrayList();
				foreach(GroupLab.Networking.SharedDictionary.Entry entry in this.sd["/*"] as IEnumerable)
				{
					al.Add((entry as GroupLab.Networking.ISerializedObjectAware).GetNetworkSafeContents(bf));
				}
				byte[] data = bf.Serialize(al);
				try
				{
					System.IO.FileStream fs = new System.IO.FileStream(this.tbFile.Text, System.IO.FileMode.Create, System.IO.FileAccess.Write, System.IO.FileShare.Read);
					try
					{
						fs.Write(data, 0, data.Length);
						MessageBox.Show(this, string.Format("Dictionary has been saved to {0}", this.tbFile.Text), "Save Dictionary", MessageBoxButtons.OK, MessageBoxIcon.Information);
					}
					catch(Exception x)
					{
						GroupLab.Networking.ExceptionMessageBox.Show(x, "While writing to the file...", false, e);
					}
					finally
					{
						fs.Close();
					}
				}
				catch(Exception x)
				{
					GroupLab.Networking.ExceptionMessageBox.Show(x, "While opening the file...", false, e);
				}
			}
			catch(Exception x)
			{
				GroupLab.Networking.ExceptionMessageBox.Show(x, "While serializing the shared dictionary contents...", false, e);
			}
		}

		private void btnUpload_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.IO.FileStream fs = new System.IO.FileStream(this.tbFile.Text, System.IO.FileMode.Open, System.IO.FileAccess.Read, System.IO.FileShare.Read);
				try
				{
					byte[] data = new byte[fs.Length];
					fs.Read(data, 0, data.Length);
					try
					{
						GroupLab.Networking.ComAwareBinaryFormatter bf = new GroupLab.Networking.ComAwareBinaryFormatter();
						ArrayList al = (ArrayList) bf.Deserialize(data, 0, data.Length);
						foreach(GroupLab.Networking.ISerializedObjectAware o in al)
						{
							o.RevertToUnsafeContents(bf);
							GroupLab.Networking.SharedDictionary.Entry entry = (GroupLab.Networking.SharedDictionary.Entry) o;
							this.sd[entry.Path] = entry.Value;
						}
						MessageBox.Show(this, string.Format("Dictionary has been uploaded from {0}", this.tbFile.Text), "Upload Dictionary", MessageBoxButtons.OK, MessageBoxIcon.Information);
					}
					catch(Exception x)
					{
						GroupLab.Networking.ExceptionMessageBox.Show(x, "While deserializing the shared dictionary contents...", false, e);
					}
				}
				catch(Exception x)
				{
					GroupLab.Networking.ExceptionMessageBox.Show(x, "While reading the file...", false, e);
				}
				finally
				{
					fs.Close();
				}
			}
			catch(Exception x)
			{
				GroupLab.Networking.ExceptionMessageBox.Show(x, "While opening the file for read access...", false, e);
			}
		}

		private void btnBrowse_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialog1.FileName = this.tbFile.Text;
			if(DialogResult.OK == this.saveFileDialog1.ShowDialog(this))
			{
				this.tbFile.Text = this.saveFileDialog1.FileName;
			}
		}

	}
}
