using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using GroupLab.Networking;

namespace notifications
{
	/// <summary>
	/// Summary description for UserControl1.
	/// </summary>
	public class mediaitem : System.Windows.Forms.UserControl
	{
		private System.ComponentModel.IContainer components;

		// Controls 
		private System.Windows.Forms.Button btnForward1;
		private System.Windows.Forms.Button btnBackwards1;
		private System.Windows.Forms.LinkLabel lblURL;
		private System.Windows.Forms.Button btnPlay;
		private System.Windows.Forms.Label lblTime;
		private System.Windows.Forms.PictureBox pbox;
		private System.Timers.Timer tmrAnimate;

		// Parent Trackbar - so we can get the Animation Speed value from it
		private System.Windows.Forms.TrackBar tbAnimateSpeed;

		// Images
		private Collabrary.IPhoto thumbnail = new Collabrary.PhotoClass();

		// Various variables / constants
		private int border = 1; // border spacing used for repainting 
		private int frame_number = 0; // what frame we are on in the animation playback

		// Key paths
		private string keyPath =		"";				// Will be set to the root path of the notification
		private string keyTitle =		"/title";		// Title of the notification
		private string keyURL =			"/url";			// URL of the source web page
		private string keyThumbnails =  "/thumbnails";	// URL of the composite thumbnail image, which is a vector map of timestamp/image

		// Maps are stored under keyThumbnails
		private string mapTimeStamp =   "timestamp";	// Timestamp in DateTime.Now format
		private string mapImage =		"image";		// PNG.Compressed image
		
		// Subscriptions
		private GroupLab.Networking.SharedDictionary sd;
		private GroupLab.Networking.Subscription subTitle;
		private GroupLab.Networking.Subscription subURL;
		private GroupLab.Networking.Subscription subThumbnails;


		// Odds and sods
		private bool first_use = true;
		private System.Windows.Forms.Label lblFrame;  // A 'virgin' media item i.e., no contents have  yet been posted to it
		private bool playing = false;   // whether or not we are in the middle of an animation playback

		#region Initalize the Media Item / Clean up resources
		// Each media item is given:
		// -the shared dictionary sd
		// -the key path to all necessary subkeys i.e., usually /items/guid
		// -the trackbar in the parent, whose value is used to adjust animation playback speed
		public mediaitem(GroupLab.Networking.SharedDictionary shared_dict, string path, System.Windows.Forms.TrackBar trackbar)
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			this.SetStyle(ControlStyles.ResizeRedraw, true);

			// Assign the arguments passed in to properties accessbile throughout the class 
			this.keyPath = path;				// the root path
			this.sd =  shared_dict;				// the shared dictionary
			this.tbAnimateSpeed = trackbar;		// the trackbar in the parent

			// Set up a separate subscription for each key
			this.subTitle.Dictionary = sd;
			this.subTitle.BeginInit(); // signal begining of initialization for subscription1
			this.subTitle.Pattern = path + keyTitle; // register the pattern with the shared dictionary server
			this.subTitle.Notified += new SubscriptionEventHandler(subTitle_notified); // register the event handler
			this.subTitle.EndInit(); // signal the end of initialization

			this.subURL.Dictionary = sd;
			this.subURL.BeginInit(); // signal begining of initialization for subscription1
			this.subURL.Pattern = path + keyURL; // register the pattern with the shared dictionary server
			this.subTitle.Notified += new SubscriptionEventHandler(subURL_Notified); // register the event handler
			this.subTitle.EndInit(); // signal the end of initialization

			this.subThumbnails.Dictionary = sd;
			this.subThumbnails.BeginInit(); // signal begining of initialization for subscription1
			this.subThumbnails.Pattern = path + keyThumbnails; // register the pattern with the shared dictionary server
			this.subThumbnails.Notified += new SubscriptionEventHandler(subThumbnails_Notified); // register the event handler
			this.subThumbnails.EndInit(); // signal the end of initialization
		}

		/// Clean up any resources being used.
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(mediaitem));
			this.pbox = new System.Windows.Forms.PictureBox();
			this.btnPlay = new System.Windows.Forms.Button();
			this.lblURL = new System.Windows.Forms.LinkLabel();
			this.lblTime = new System.Windows.Forms.Label();
			this.subTitle = new GroupLab.Networking.Subscription(this.components);
			this.subURL = new GroupLab.Networking.Subscription(this.components);
			this.subThumbnails = new GroupLab.Networking.Subscription(this.components);
			this.tmrAnimate = new System.Timers.Timer();
			this.btnForward1 = new System.Windows.Forms.Button();
			this.btnBackwards1 = new System.Windows.Forms.Button();
			this.lblFrame = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.subTitle)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.subURL)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.subThumbnails)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tmrAnimate)).BeginInit();
			this.SuspendLayout();
			// 
			// pbox
			// 
			this.pbox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pbox.Location = new System.Drawing.Point(0, 0);
			this.pbox.Name = "pbox";
			this.pbox.Size = new System.Drawing.Size(120, 92);
			this.pbox.TabIndex = 0;
			this.pbox.TabStop = false;
			// 
			// btnPlay
			// 
			this.btnPlay.Image = ((System.Drawing.Image)(resources.GetObject("btnPlay.Image")));
			this.btnPlay.Location = new System.Drawing.Point(24, 112);
			this.btnPlay.Name = "btnPlay";
			this.btnPlay.Size = new System.Drawing.Size(24, 32);
			this.btnPlay.TabIndex = 1;
			this.btnPlay.Click += new System.EventHandler(this.btnPlay_Click);
			// 
			// lblURL
			// 
			this.lblURL.ImageAlign = System.Drawing.ContentAlignment.TopLeft;
			this.lblURL.Location = new System.Drawing.Point(0, 96);
			this.lblURL.Name = "lblURL";
			this.lblURL.Size = new System.Drawing.Size(112, 16);
			this.lblURL.TabIndex = 2;
			this.lblURL.TabStop = true;
			this.lblURL.Text = "URL";
			this.lblURL.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lblURL_LinkClicked);
			// 
			// lblTime
			// 
			this.lblTime.Location = new System.Drawing.Point(72, 112);
			this.lblTime.Name = "lblTime";
			this.lblTime.Size = new System.Drawing.Size(80, 16);
			this.lblTime.TabIndex = 3;
			this.lblTime.Text = "Time";
			// 
			// subTitle
			// 
			this.subTitle.Notified += new GroupLab.Networking.SubscriptionEventHandler(this.subTitle_notified);
			// 
			// subURL
			// 
			this.subURL.Notified += new GroupLab.Networking.SubscriptionEventHandler(this.subURL_Notified);
			// 
			// tmrAnimate
			// 
			this.tmrAnimate.SynchronizingObject = this;
			this.tmrAnimate.Elapsed += new System.Timers.ElapsedEventHandler(this.tmrAnimate_Elapsed);
			// 
			// btnForward1
			// 
			this.btnForward1.Image = ((System.Drawing.Image)(resources.GetObject("btnForward1.Image")));
			this.btnForward1.Location = new System.Drawing.Point(48, 112);
			this.btnForward1.Name = "btnForward1";
			this.btnForward1.Size = new System.Drawing.Size(24, 32);
			this.btnForward1.TabIndex = 4;
			this.btnForward1.Click += new System.EventHandler(this.btnForward1_Click);
			// 
			// btnBackwards1
			// 
			this.btnBackwards1.Image = ((System.Drawing.Image)(resources.GetObject("btnBackwards1.Image")));
			this.btnBackwards1.Location = new System.Drawing.Point(0, 112);
			this.btnBackwards1.Name = "btnBackwards1";
			this.btnBackwards1.Size = new System.Drawing.Size(24, 32);
			this.btnBackwards1.TabIndex = 5;
			this.btnBackwards1.Click += new System.EventHandler(this.btnBackwards1_Click);
			// 
			// lblFrame
			// 
			this.lblFrame.Location = new System.Drawing.Point(72, 128);
			this.lblFrame.Name = "lblFrame";
			this.lblFrame.Size = new System.Drawing.Size(80, 16);
			this.lblFrame.TabIndex = 6;
			this.lblFrame.Text = "0 / 0 frames";
			// 
			// mediaitem
			// 
			this.Controls.Add(this.lblFrame);
			this.Controls.Add(this.btnBackwards1);
			this.Controls.Add(this.btnForward1);
			this.Controls.Add(this.lblTime);
			this.Controls.Add(this.lblURL);
			this.Controls.Add(this.btnPlay);
			this.Controls.Add(this.pbox);
			this.Name = "mediaitem";
			this.Size = new System.Drawing.Size(168, 144);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.mediaitem_Paint);
			((System.ComponentModel.ISupportInitialize)(this.subTitle)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.subURL)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.subThumbnails)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tmrAnimate)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion
		
		#region Repainting and Resizing
		//
		// Repainting and Resizing
		//
		private void mediaitem_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
//			GroupLab.Networking.SharedDictionary.Vector v;
//			try 
//			{
//				v = sd[keyPath + keyThumbnails] as GroupLab.Networking.SharedDictionary.Vector; 
//				this.Parent.Visible = true;
//			} 
//			catch 
//			{
//				this.Parent.Visible = false;
//			}

			this.btnBackwards1.Left = 0;
			this.btnBackwards1.Top = this.Height - btnBackwards1.Height;
			
			this.btnPlay.Left = this.btnBackwards1.Left + this.btnBackwards1.Width + this.border;
			this.btnPlay.Top = this.btnBackwards1.Top;

			this.btnForward1.Left = this.btnPlay.Left + this.btnPlay.Width + this.border;
			this.btnForward1.Top = this.btnBackwards1.Top;
			
			lblTime.Left = this.btnForward1.Left + this.btnForward1.Width + this.border;
			lblTime.Top = this.btnPlay.Top; 
			lblTime.Width = this.Width - lblTime.Width - this.border;

			lblFrame.Left = lblTime.Left;
			lblFrame.Width = lblTime.Width;
			lblFrame.Top = lblTime.Top + lblTime.Height;

			lblURL.Left = 0;
			lblURL.Top = this.btnBackwards1.Top - this.lblURL.Height - this.border;
			lblURL.Width = this.Width - this.border; 
 
			pbox.Left = 0;
			pbox.Top = 0;
			pbox.Width = this.Width;
			pbox.Height = lblURL.Top - border;	
			thumbnail_toImage (thumbnail, pbox.Width, pbox.Height);		
		}
		#endregion

		private void thumbnail_toImage (Collabrary.IPhoto thumb, int cwidth, int cheight)
		{
			if (thumb.Width == 0) return ;
			Collabrary.IPhoto copy =  (Collabrary.IPhoto) thumb.Copy (0,0,0,0,Collabrary.PhotoCopyStyle.Pixels);

			int new_width = cwidth;
			int new_height = (int) ( (cwidth * copy.Height) / copy.Width); 
			copy.Resize (new_width, new_height, true);
			pbox.Image = Image.FromHbitmap (copy.Hbitmap);
		}

		#region Subscriptions
		//
		// Subscription Notifications
		//
		private void subTitle_notified(object sender, GroupLab.Networking.SubscriptionEventArgs e)
		{
			if (e.Value.ToString () == "") 
			{
				this.Parent.Text = "Notification";
			} 
			else {
				this.Parent.Text = e.Value.ToString ();
			}
		}

		private void subURL_Notified(object sender, GroupLab.Networking.SubscriptionEventArgs e)
		{
			this.lblURL.Text = e.Value.ToString ();
		}

		private void subThumbnails_Notified(object sender, GroupLab.Networking.SubscriptionEventArgs e)
		{
			//We are in the middle of playing things back, don't display the notifiation.
			if (this.playing) return; 

			// This will be a vector. Make sure there is something in it before doing anything.
			GroupLab.Networking.SharedDictionary.Vector v = sd[keyPath + keyThumbnails] as GroupLab.Networking.SharedDictionary.Vector; 
			if (v.Count <= 0 ) return;

			
			// Each entry in the vector is a map. Get the very last map entry in the vector
			Map m = (Map) v[v.Count - 1];

			// Now set the notification display to reflect the content of this map
			this.lblTime.Text = toTime (m[mapTimeStamp]);			// The Time
			pbox.Image = null;										// The (PNG Compressed) image
			Collabrary.PNGClass png = new Collabrary.PNGClass ();
			this.thumbnail = (Collabrary.IPhoto) png.Decompress ((Collabrary.IMemory) m[mapImage]);

			// This is the first time the notification is being displayed, so resize it 
			// to fit the thumbnail
			if (this.first_use) 
			{
				this.Parent.Width = thumbnail.Width + 5;
				this.Parent.Height = thumbnail.Height + btnPlay.Height + lblURL.Height + 28;
				thumbnail_toImage (this.thumbnail, thumbnail.Width, thumbnail.Height);
				first_use = false;
			} 
			else 
			{
				thumbnail_toImage (this.thumbnail, pbox.Width, pbox.Height);
			}

			this.frame_number = v.Count - 1;
			this.Parent.Visible = true;	
			
			bool showButtons = (v.Count > 1);
			this.btnBackwards1.Enabled = showButtons;
			this.btnPlay.Enabled = showButtons;
			this.btnForward1.Enabled = showButtons;

			showCurrentFrameNumber (this.frame_number, v.Count);
		}
#endregion 
		private void lblURL_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(lblURL.Text);
			}
			catch(Exception)
			{
				MessageBox.Show("Unable to open link that was clicked.");
			}
		}
		#region Playback of Notifictions
		//
		// Playback of Notifications
		//

		// Play all frames (activates a timer which does the actual animation)
		private void btnPlay_Click(object sender, System.EventArgs e)
		{
			this.playing = true;
			this.lblTime.Text = "rewinding...";
			tmrAnimate.Interval =  this.tbAnimateSpeed.Value;
			this.frame_number = -1;
			tmrAnimate.Enabled = true;
		}

		// Go forward one frame
		private void btnForward1_Click(object sender, System.EventArgs e)
		{
			frame_number++;
			GroupLab.Networking.SharedDictionary.Vector v;
			v = sd[keyPath + keyThumbnails] as GroupLab.Networking.SharedDictionary.Vector; 
			if (this.frame_number >= v.Count) this.frame_number = 0;	
			show_frame (frame_number);
			showCurrentFrameNumber (frame_number, v.Count);
			
		}

		// Go back one frame
		private void btnBackwards1_Click(object sender, System.EventArgs e)
		{
			frame_number--;
			GroupLab.Networking.SharedDictionary.Vector v;
			v = sd[keyPath + keyThumbnails] as GroupLab.Networking.SharedDictionary.Vector; 
			if (this.frame_number < 0) 
			{
				this.frame_number = v.Count - 1;	
			}
			show_frame (frame_number);
			showCurrentFrameNumber (frame_number, v.Count);	
		}

		// The timer animates the image playback by showing the current frame
		private void tmrAnimate_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			this.frame_number++;
			GroupLab.Networking.SharedDictionary.Vector v;
			v = sd[keyPath + keyThumbnails] as GroupLab.Networking.SharedDictionary.Vector; 
			
			// If there are still images left, we can show the next one.
			if (frame_number < v.Count) 
			{
				show_frame (frame_number);
				showCurrentFrameNumber (frame_number, v.Count);
				tmrAnimate.Interval = this.tbAnimateSpeed.Value;;
			} 
			else  
			{
				// There are no images left, so we can stop animating
				tmrAnimate.Enabled = false;
				frame_number = v.Count - 1;
				this.playing = false;
			}
		}

		// Show the frame given by the index
		private void show_frame (int index)
		{
			GroupLab.Networking.SharedDictionary.Vector v;
			v = sd[keyPath + keyThumbnails] as GroupLab.Networking.SharedDictionary.Vector; 
			Map m =  (Map) v[index];
			this.lblTime.Text = toTime (m[mapTimeStamp]);
		
			//pbox.Image = null;
			Collabrary.PNGClass png = new Collabrary.PNGClass ();
			Collabrary.IPhoto thumb = (Collabrary.IPhoto) png.Decompress ((Collabrary.IMemory) m["image"]);
			thumbnail_toImage (thumb, pbox.Width, pbox.Height);
			this.pbox.Refresh ();
			this.lblTime.Refresh ();
			this.lblFrame.Refresh ();
		}
		#endregion

		#region Utility Routines
		//
		// Utilities
		//
		private string toTime (object time)
		{
			System.DateTime t = (System.DateTime) time;
			return (t.ToLongTimeString ());
		}

		private void showCurrentFrameNumber (int index, int count)
		{
			index++;
			lblFrame.Text = index.ToString () + " / " + count.ToString() + " frames";
		}
		#endregion
	}
}
