using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;

namespace WebTracker
{
	public class UrlGrabber
	{
		public static Color ToGray(Color c)
		{
			if(c == Color.Transparent)
			{
				return Color.Transparent;
			}
			else
			{
				int a = (127 + c.B + c.G + c.R) >> 2;
				return Color.FromArgb(c.A, a, a, a);
			}
		}
		public static object ToPng(Bitmap b)
		{
			Collabrary.PNG png = new Collabrary.PNGClass();
			Collabrary.Photo p = new Collabrary.PhotoClass();
			try
			{
				BitmapData bd = b.LockBits(new Rectangle(0, 0, b.Width, b.Height), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);
				try
				{
					p.SetSize(bd.Width, bd.Height);
					p.PasteBitmapData((int) bd.Scan0, bd.Width, bd.Height, bd.Stride);
				}
				finally
				{
					b.UnlockBits(bd);
				}
				return png.Compress(p);
			}
			catch(Exception e)
			{
				System.Diagnostics.Debug.WriteLine(string.Format("WARNING: {0}", e));
				return null;
			}
			finally
			{
				Marshal.ReleaseComObject(png);
				Marshal.ReleaseComObject(p);
			}
		}
		public unsafe static void DrawImageGrayscale(Graphics g, Bitmap image, Rectangle dst, Rectangle src, GraphicsUnit gp)
		{
			if(image == null)
			{
				return;
			}
			Bitmap bm = new Bitmap(dst.Width, dst.Height, PixelFormat.Format24bppRgb);
			try
			{
				using(Graphics g2 = Graphics.FromImage(bm))
				{
					g2.DrawImage(image, new Rectangle(0, 0, dst.Width, dst.Height), src, gp);
					g2.Flush(System.Drawing.Drawing2D.FlushIntention.Sync);
				}
				BitmapData bd = bm.LockBits(new Rectangle(0, 0, bm.Width, bm.Height), ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);
				try
				{
					for(int y = bm.Height - 1; y >= 0; y--)
					{
						byte* pd = ((byte*)((void*)bd.Scan0)) + y * bd.Stride;
						for(int x = bm.Width - 1; x >= 0; x--)
						{
							byte b = (byte) ((127 + pd[0] + pd[1] + pd[2]) >> 2);
							pd[0] = b;
							pd[1] = b;
							pd[2] = b;
							pd += 3;
						}
					}
				}
				finally
				{
					bm.UnlockBits(bd);
				}
				g.DrawImage(bm, dst);
			}
			catch(Exception e)
			{
				System.Diagnostics.Debug.WriteLine(string.Format("WARNING: {0}", e));
			}
			finally
			{
				bm.Dispose();
			}
		}

		public static Bitmap Grab(string url, out string title)
		{
			string msg = "No web page specified.";
			if(url != string.Empty)
			{
				try
				{
					return GrabOnline(url, out title);
				}
				catch(Exception e)
				{
					msg = string.Format("The page you requested could not be rendered. Exception details: {0}", e);
				}
			}
			Bitmap image = new Bitmap(800, 600, PixelFormat.Format24bppRgb);
			using(Graphics g = Graphics.FromImage(image))
			{
				g.Clear(Color.White);
				using(Brush b = new SolidBrush(Color.Black))
				{
					using(StringFormat strfmt = new StringFormat(StringFormat.GenericTypographic))
					{
						strfmt.Alignment = StringAlignment.Center;
						strfmt.LineAlignment = StringAlignment.Center;
						using(Font font = new Font("Times New Roman", 22, GraphicsUnit.Pixel))
						{
							g.DrawString(msg, font, b, new RectangleF(0, 0, 800, 600), strfmt);
						}
					}
				}
			}	
			title = string.Empty;
			return image;
		}
		private static Bitmap GrabOnline(string url, out string title)
		{
			Collabrary.Photo p = new Collabrary.PhotoClass();
			try
			{
				p.Grab(url);
				title = p.GrabbedUrlDocumentTitle;
				return Bitmap.FromHbitmap(p.Hbitmap);
			}
			finally
			{
				Marshal.ReleaseComObject(p);
			}
		}
	}
}
