using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace WebTracker
{
	/// <summary>
	/// Summary description for TestResultsForm.
	/// </summary>
	public class TestResultsForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private WebTracker.Canvas canvas1;

		public TestResultsForm(WebPageNotification n)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			int y = 0, x = 0;
			this.canvas1.BeginUpdate();
			for(int i = 0; i < n.ChangeRegions.Length; i++)
			{
				x = 0;
				Shape orig = new Shape(this.canvas1);
				orig.Image = n.PreviousImage;
				orig.ImageRectangle = n.ChangeRegions[i].PrevSource;
				orig.Text = string.Format("{0}: First", n.ChangeRegions[i].Text);
				orig.Rectangle = new Rectangle(new Point(x, y), orig.ImageRectangle.Size);
				this.canvas1.Shapes.Add(orig);
				x += orig.ImageRectangle.Width + 27;
				Shape orig2 = new Shape(this.canvas1);
				orig2.Image = n.Image;
				orig2.ImageRectangle = n.ChangeRegions[i].Source;
				orig2.Text = string.Format("{0}: Second", n.ChangeRegions[i].Text);
				orig2.Rectangle = new Rectangle(new Point(x, y), orig2.ImageRectangle.Size);
				this.canvas1.Shapes.Add(orig2);
				x += orig2.ImageRectangle.Width + 27;
				Shape diff = new Shape(this.canvas1);
				if(n.ChangeRegions[i].Changed)
				{
					diff.ForeColor = Color.Orange;
				}
				else
				{
					diff.ForeColor = Color.Navy;
				}
				diff.Image = n.ChangeRegions[i].DifferenceImage;
				diff.ImageRectangle = new Rectangle(Point.Empty, diff.Image.Size);
				if(double.IsInfinity(n.ChangeRegions[i].PSNR))
				{
					diff.Text = string.Format("{0}: No Differences", n.ChangeRegions[i].Text);
				}
				else
				{
					diff.Text = string.Format("{0}: Difference: {1:0.0}", n.ChangeRegions[i].Text, n.ChangeRegions[i].PSNR);
				}
				diff.Rectangle = new Rectangle(new Point(x,y), diff.Image.Size);
				this.canvas1.Shapes.Add(diff);
				y += 27 + Math.Max(diff.ImageRectangle.Height, Math.Max(orig.ImageRectangle.Height, orig2.ImageRectangle.Height));
			}
			x = 0;
			Shape q = new Shape(this.canvas1);
			q.Image = n.CompositeImage;
			q.ImageRectangle = new Rectangle(new Point(0, 0), q.Image.Size);
			q.Rectangle = new Rectangle(new Point(0, y), q.Image.Size);
			q.Text = "Notification";
			this.canvas1.Shapes.Add(q);
			x += 27 + q.Rectangle.Width;
			q = new Shape(this.canvas1);
			q.Image = n.FullPageThumbnail;
			q.ImageRectangle = new Rectangle(new Point(0, 0), q.Image.Size);
			q.Rectangle = new Rectangle(new Point(x, y), q.Image.Size);
			q.Text = "Full Page (Thumbnail)";
			this.canvas1.Shapes.Add(q);
			this.canvas1.EndUpdate();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.canvas1 = new WebTracker.Canvas();
			this.SuspendLayout();
			// 
			// canvas1
			// 
			this.canvas1.AutoScroll = true;
			this.canvas1.BackColor = System.Drawing.Color.White;
			this.canvas1.BorderSelect = false;
			this.canvas1.BorderStyle = System.Drawing.Drawing2D.HatchStyle.DarkDownwardDiagonal;
			this.canvas1.BorderThickness = 5;
			this.canvas1.CanvasSize = new System.Drawing.Size(0, 0);
			this.canvas1.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.canvas1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.canvas1.DrawMode = false;
			this.canvas1.ForeColor = System.Drawing.Color.Black;
			this.canvas1.HandleSize = new System.Drawing.Size(9, 9);
			this.canvas1.HandleVisibility = WebTracker.HandleVisibility.Never;
			this.canvas1.Location = new System.Drawing.Point(0, 0);
			this.canvas1.MaximumSize = new System.Drawing.Size(2147483647, 2147483647);
			this.canvas1.MinimumSize = new System.Drawing.Size(12, 12);
			this.canvas1.Movable = false;
			this.canvas1.Name = "canvas1";
			this.canvas1.Resizable = false;
			this.canvas1.Size = new System.Drawing.Size(544, 598);
			this.canvas1.TabIndex = 0;
			this.canvas1.TextLocked = false;
			this.canvas1.TextPlacement = System.Drawing.ContentAlignment.TopCenter;
			this.canvas1.TextVisible = true;
			// 
			// TestResultsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 598);
			this.Controls.Add(this.canvas1);
			this.Name = "TestResultsForm";
			this.Text = "Test Results";
			this.ResumeLayout(false);

		}
		#endregion

	}
}
