using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.IO;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using GroupLab.Networking;

namespace WebTracker
{
	public class EditorForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button goButton;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Panel addressPanel;
		private System.Windows.Forms.TextBox addressTextBox;
		private System.Windows.Forms.Label addressLabel;
		private System.Windows.Forms.Panel mainLowerPanel;
		private System.Windows.Forms.ToolBar toolBar1;
		private System.Windows.Forms.ToolBarButton arrowButton;
		private System.Windows.Forms.ToolBarButton drawCopyRectangle;
		private System.Windows.Forms.ToolBarButton drawChangeRegion;
		private System.Windows.Forms.ToolBarButton toolBarButton1;
		private System.Windows.Forms.ToolBarButton toolBarButton4;
		private System.Windows.Forms.ToolBarButton toolBarButton5;
		private System.Windows.Forms.ToolBarButton toolBarButton6;
		private System.Windows.Forms.ToolBarButton toolBarButton8;
		private System.Windows.Forms.ToolBarButton toolBarButton7;
		private System.Windows.Forms.ToolBarButton toolBarButton9;
		private System.Windows.Forms.Panel innerMainLowerPanel;
		private System.Windows.Forms.Panel rightPanel;
		private System.Windows.Forms.Splitter leftRightSplitter;
		private System.Windows.Forms.GroupBox webPageGroupBox;
		private System.Windows.Forms.GroupBox propertiesGroupBox;
		private System.Windows.Forms.GroupBox thumbnailGroupBox;
		private WebTracker.Canvas webPageCanvas;
		private WebTracker.Canvas thumbnailCanvas;
		private System.Windows.Forms.ToolBarButton openButton;
		private System.Windows.Forms.ToolBarButton saveButton;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		private System.Windows.Forms.ToolBarButton trackChangesButton;
		private System.Windows.Forms.ToolBarButton toolBarButton2;
		private System.Windows.Forms.Timer trackTimer;
		private GroupLab.Networking.SharedDictionary sharedDictionary1;
		private System.Windows.Forms.ToolBarButton inspectToolbarButton;
		private System.Windows.Forms.ToolBarButton bringToFrontButton;
		private System.Windows.Forms.ToolBarButton sendToBackButton;
		private System.Windows.Forms.Panel changeRegionPropertiesPanel;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox changeRegionTextBox;
		private System.Windows.Forms.TrackBar changeRegionSlider;
		private System.Windows.Forms.GroupBox PagePropertiesGroupBox;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.RadioButton compositeViewRadioButton;
		private System.Windows.Forms.RadioButton fullPageRadioButton;
		private System.Windows.Forms.Label pollingFrequencyLabel;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TrackBar pollingFrequency;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Label thresholdLabel;
		private System.Windows.Forms.ToolBarButton testToolbarButton;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ToolBarButton toolBarButton3;
		private System.Windows.Forms.Label howMuchLabel;
		private System.Windows.Forms.Button nextShapeButton;
		private System.Windows.Forms.Button prevShapeButton;
		private System.Windows.Forms.Timer animateStatusTimer;
		private System.Windows.Forms.ToolBarButton newButton;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.TextBox pageTitleTextBox;
		private System.Windows.Forms.CheckBox recordHistoryCheckBox;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.ToolBarButton drawLandmark;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.ComboBox landmarkComboBox;

		private int[] PollingFrequencies=new int[]{15, 30, 60, 120, 300, 600, 900,
                                                1200, 1500, 1800, 2700, 3600,
                                                5400, 7200, 10800, 14400, 21600,
                                                28800, 43200, 86400, 172800,
																								259200, 432000, 604800};
		Cursor oldCursor;
		string root = "/items/" + Guid.NewGuid().ToString();
		WebPageNotification notification = new WebPageNotification();
		private Thread theThread = null;
		Type nextRegionType = typeof(CopyRegion);
		Form dictInspForm = null;
		object timerGoLock = new object();
		bool timerGo = false;
		char[] timerChars = new char[]{'|', '/', '-', '\\'};
		int timerGoLevel = 0;
		string timerStatusText = string.Empty;
		const int GRID_SIZE_X = 3;
		const int GRID_SIZE_Y = 3;
		bool testing = false;
		bool tracking = false;
		int generation = 0;

		public EditorForm()
		{
			InitializeComponent();
			this.fileName = this.DEFAULT_FILE_NAME;
			this.Text = string.Format("Web Page Notification Editor - {0}", System.IO.Path.GetFileName(this.fileName));
			this.pollingFrequency.Minimum = 0;
			this.pollingFrequency.Maximum = PollingFrequencies.Length - 1;
		}

		#region Windows Form Designer generated code
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(EditorForm));
			this.sharedDictionary1 = new GroupLab.Networking.SharedDictionary(this.components);
			this.addressPanel = new System.Windows.Forms.Panel();
			this.addressTextBox = new System.Windows.Forms.TextBox();
			this.goButton = new System.Windows.Forms.Button();
			this.addressLabel = new System.Windows.Forms.Label();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.animateStatusTimer = new System.Windows.Forms.Timer(this.components);
			this.mainLowerPanel = new System.Windows.Forms.Panel();
			this.innerMainLowerPanel = new System.Windows.Forms.Panel();
			this.webPageGroupBox = new System.Windows.Forms.GroupBox();
			this.webPageCanvas = new WebTracker.Canvas();
			this.leftRightSplitter = new System.Windows.Forms.Splitter();
			this.rightPanel = new System.Windows.Forms.Panel();
			this.thumbnailGroupBox = new System.Windows.Forms.GroupBox();
			this.thumbnailCanvas = new WebTracker.Canvas();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.PagePropertiesGroupBox = new System.Windows.Forms.GroupBox();
			this.recordHistoryCheckBox = new System.Windows.Forms.CheckBox();
			this.pageTitleTextBox = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.compositeViewRadioButton = new System.Windows.Forms.RadioButton();
			this.fullPageRadioButton = new System.Windows.Forms.RadioButton();
			this.pollingFrequencyLabel = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.pollingFrequency = new System.Windows.Forms.TrackBar();
			this.label1 = new System.Windows.Forms.Label();
			this.propertiesGroupBox = new System.Windows.Forms.GroupBox();
			this.changeRegionPropertiesPanel = new System.Windows.Forms.Panel();
			this.landmarkComboBox = new System.Windows.Forms.ComboBox();
			this.label5 = new System.Windows.Forms.Label();
			this.nextShapeButton = new System.Windows.Forms.Button();
			this.prevShapeButton = new System.Windows.Forms.Button();
			this.thresholdLabel = new System.Windows.Forms.Label();
			this.changeRegionSlider = new System.Windows.Forms.TrackBar();
			this.howMuchLabel = new System.Windows.Forms.Label();
			this.changeRegionTextBox = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.toolBar1 = new System.Windows.Forms.ToolBar();
			this.arrowButton = new System.Windows.Forms.ToolBarButton();
			this.drawCopyRectangle = new System.Windows.Forms.ToolBarButton();
			this.drawChangeRegion = new System.Windows.Forms.ToolBarButton();
			this.drawLandmark = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton1 = new System.Windows.Forms.ToolBarButton();
			this.newButton = new System.Windows.Forms.ToolBarButton();
			this.openButton = new System.Windows.Forms.ToolBarButton();
			this.saveButton = new System.Windows.Forms.ToolBarButton();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.toolBarButton4 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton5 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton6 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton8 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton7 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton9 = new System.Windows.Forms.ToolBarButton();
			this.bringToFrontButton = new System.Windows.Forms.ToolBarButton();
			this.sendToBackButton = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton2 = new System.Windows.Forms.ToolBarButton();
			this.trackChangesButton = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton3 = new System.Windows.Forms.ToolBarButton();
			this.inspectToolbarButton = new System.Windows.Forms.ToolBarButton();
			this.testToolbarButton = new System.Windows.Forms.ToolBarButton();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			this.trackTimer = new System.Windows.Forms.Timer(this.components);
			this.addressPanel.SuspendLayout();
			this.mainLowerPanel.SuspendLayout();
			this.innerMainLowerPanel.SuspendLayout();
			this.webPageGroupBox.SuspendLayout();
			this.rightPanel.SuspendLayout();
			this.thumbnailGroupBox.SuspendLayout();
			this.PagePropertiesGroupBox.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.pollingFrequency)).BeginInit();
			this.propertiesGroupBox.SuspendLayout();
			this.changeRegionPropertiesPanel.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.changeRegionSlider)).BeginInit();
			this.SuspendLayout();
			// 
			// sharedDictionary1
			// 
			this.sharedDictionary1.SynchronizingObject = this;
			this.sharedDictionary1.Url = "tcp://localhost:webnotif";
			// 
			// addressPanel
			// 
			this.addressPanel.Controls.Add(this.addressTextBox);
			this.addressPanel.Controls.Add(this.goButton);
			this.addressPanel.Controls.Add(this.addressLabel);
			this.addressPanel.Dock = System.Windows.Forms.DockStyle.Top;
			this.addressPanel.DockPadding.All = 8;
			this.addressPanel.Location = new System.Drawing.Point(0, 0);
			this.addressPanel.Name = "addressPanel";
			this.addressPanel.Size = new System.Drawing.Size(864, 40);
			this.addressPanel.TabIndex = 1;
			// 
			// addressTextBox
			// 
			this.addressTextBox.AcceptsReturn = true;
			this.addressTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.addressTextBox.Location = new System.Drawing.Point(57, 8);
			this.addressTextBox.Name = "addressTextBox";
			this.addressTextBox.Size = new System.Drawing.Size(711, 20);
			this.addressTextBox.TabIndex = 2;
			this.addressTextBox.Text = "";
			this.addressTextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.addressTextBox_KeyPress);
			// 
			// goButton
			// 
			this.goButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.goButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.goButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.goButton.Location = new System.Drawing.Point(776, 8);
			this.goButton.Name = "goButton";
			this.goButton.Size = new System.Drawing.Size(80, 24);
			this.goButton.TabIndex = 1;
			this.goButton.Text = "Go";
			this.goButton.Click += new System.EventHandler(this.goButton_Click);
			// 
			// addressLabel
			// 
			this.addressLabel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.addressLabel.Location = new System.Drawing.Point(8, 10);
			this.addressLabel.Name = "addressLabel";
			this.addressLabel.Size = new System.Drawing.Size(49, 20);
			this.addressLabel.TabIndex = 0;
			this.addressLabel.Text = "Address ";
			this.addressLabel.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Silver;
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 663);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(864, 22);
			this.statusBar1.TabIndex = 3;
			// 
			// animateStatusTimer
			// 
			this.animateStatusTimer.Interval = 700;
			this.animateStatusTimer.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// mainLowerPanel
			// 
			this.mainLowerPanel.Controls.Add(this.innerMainLowerPanel);
			this.mainLowerPanel.Controls.Add(this.toolBar1);
			this.mainLowerPanel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.mainLowerPanel.Location = new System.Drawing.Point(0, 40);
			this.mainLowerPanel.Name = "mainLowerPanel";
			this.mainLowerPanel.Size = new System.Drawing.Size(864, 623);
			this.mainLowerPanel.TabIndex = 4;
			// 
			// innerMainLowerPanel
			// 
			this.innerMainLowerPanel.BackColor = System.Drawing.Color.White;
			this.innerMainLowerPanel.Controls.Add(this.webPageGroupBox);
			this.innerMainLowerPanel.Controls.Add(this.leftRightSplitter);
			this.innerMainLowerPanel.Controls.Add(this.rightPanel);
			this.innerMainLowerPanel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.innerMainLowerPanel.DockPadding.Bottom = 4;
			this.innerMainLowerPanel.DockPadding.Left = 4;
			this.innerMainLowerPanel.Location = new System.Drawing.Point(0, 72);
			this.innerMainLowerPanel.Name = "innerMainLowerPanel";
			this.innerMainLowerPanel.Size = new System.Drawing.Size(864, 551);
			this.innerMainLowerPanel.TabIndex = 2;
			// 
			// webPageGroupBox
			// 
			this.webPageGroupBox.Controls.Add(this.webPageCanvas);
			this.webPageGroupBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.webPageGroupBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.webPageGroupBox.Location = new System.Drawing.Point(4, 0);
			this.webPageGroupBox.Name = "webPageGroupBox";
			this.webPageGroupBox.Size = new System.Drawing.Size(481, 547);
			this.webPageGroupBox.TabIndex = 2;
			this.webPageGroupBox.TabStop = false;
			this.webPageGroupBox.Text = "Web Page";
			// 
			// webPageCanvas
			// 
			this.webPageCanvas.AutoScroll = true;
			this.webPageCanvas.BackColor = System.Drawing.Color.Tan;
			this.webPageCanvas.BorderSelect = false;
			this.webPageCanvas.BorderStyle = System.Drawing.Drawing2D.HatchStyle.DarkDownwardDiagonal;
			this.webPageCanvas.BorderThickness = 5;
			this.webPageCanvas.CanvasSize = new System.Drawing.Size(0, 0);
			this.webPageCanvas.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.webPageCanvas.Dock = System.Windows.Forms.DockStyle.Fill;
			this.webPageCanvas.DrawMode = false;
			this.webPageCanvas.ForeColor = System.Drawing.Color.Black;
			this.webPageCanvas.HandleSize = new System.Drawing.Size(9, 9);
			this.webPageCanvas.HandleVisibility = WebTracker.HandleVisibility.WhenSelected;
			this.webPageCanvas.Image = null;
			this.webPageCanvas.Location = new System.Drawing.Point(3, 16);
			this.webPageCanvas.MaximumSize = new System.Drawing.Size(2147483647, 2147483647);
			this.webPageCanvas.MinimumSize = new System.Drawing.Size(12, 12);
			this.webPageCanvas.Movable = true;
			this.webPageCanvas.Name = "webPageCanvas";
			this.webPageCanvas.Resizable = true;
			this.webPageCanvas.Size = new System.Drawing.Size(475, 528);
			this.webPageCanvas.TabIndex = 0;
			this.webPageCanvas.TextLocked = false;
			this.webPageCanvas.TextPlacement = System.Drawing.ContentAlignment.TopCenter;
			this.webPageCanvas.TextVisible = true;
			this.webPageCanvas.KeyDown += new System.Windows.Forms.KeyEventHandler(this.webPageCanvas_KeyDown);
			this.webPageCanvas.EndDragShape += new WebTracker.ShapeEventHandler(this.webPageCanvas_EndDragShape);
			this.webPageCanvas.ShapeAdded += new WebTracker.ShapeEventHandler(this.webPageCanvas_ShapeAdded);
			this.webPageCanvas.ShapeRemoved += new WebTracker.ShapeEventHandler(this.webPageCanvas_ShapeRemoved);
			this.webPageCanvas.KeyUp += new System.Windows.Forms.KeyEventHandler(this.webPageCanvas_KeyUp);
			this.webPageCanvas.BeginDrawing += new WebTracker.ShapeEventHandler(this.webPageCanvas_BeginDrawing);
			this.webPageCanvas.SelectionChanged += new WebTracker.ShapeEventHandler(this.webPageCanvas_SelectionChanged);
			// 
			// leftRightSplitter
			// 
			this.leftRightSplitter.Dock = System.Windows.Forms.DockStyle.Right;
			this.leftRightSplitter.Location = new System.Drawing.Point(485, 0);
			this.leftRightSplitter.MinSize = 360;
			this.leftRightSplitter.Name = "leftRightSplitter";
			this.leftRightSplitter.Size = new System.Drawing.Size(3, 547);
			this.leftRightSplitter.TabIndex = 1;
			this.leftRightSplitter.TabStop = false;
			// 
			// rightPanel
			// 
			this.rightPanel.Controls.Add(this.thumbnailGroupBox);
			this.rightPanel.Controls.Add(this.splitter1);
			this.rightPanel.Controls.Add(this.PagePropertiesGroupBox);
			this.rightPanel.Controls.Add(this.propertiesGroupBox);
			this.rightPanel.Dock = System.Windows.Forms.DockStyle.Right;
			this.rightPanel.DockPadding.Right = 4;
			this.rightPanel.Location = new System.Drawing.Point(488, 0);
			this.rightPanel.Name = "rightPanel";
			this.rightPanel.Size = new System.Drawing.Size(376, 547);
			this.rightPanel.TabIndex = 0;
			// 
			// thumbnailGroupBox
			// 
			this.thumbnailGroupBox.Controls.Add(this.thumbnailCanvas);
			this.thumbnailGroupBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.thumbnailGroupBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.thumbnailGroupBox.Location = new System.Drawing.Point(0, 459);
			this.thumbnailGroupBox.Name = "thumbnailGroupBox";
			this.thumbnailGroupBox.Size = new System.Drawing.Size(372, 88);
			this.thumbnailGroupBox.TabIndex = 2;
			this.thumbnailGroupBox.TabStop = false;
			this.thumbnailGroupBox.Text = "Notification";
			// 
			// thumbnailCanvas
			// 
			this.thumbnailCanvas.AutoScroll = true;
			this.thumbnailCanvas.BackColor = System.Drawing.Color.Black;
			this.thumbnailCanvas.BorderSelect = false;
			this.thumbnailCanvas.BorderStyle = System.Drawing.Drawing2D.HatchStyle.DarkDownwardDiagonal;
			this.thumbnailCanvas.BorderThickness = 3;
			this.thumbnailCanvas.CanvasSize = new System.Drawing.Size(0, 0);
			this.thumbnailCanvas.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.thumbnailCanvas.Dock = System.Windows.Forms.DockStyle.Fill;
			this.thumbnailCanvas.DrawMode = false;
			this.thumbnailCanvas.ForeColor = System.Drawing.Color.Black;
			this.thumbnailCanvas.HandleSize = new System.Drawing.Size(3, 3);
			this.thumbnailCanvas.HandleVisibility = WebTracker.HandleVisibility.WhenSelected;
			this.thumbnailCanvas.Image = null;
			this.thumbnailCanvas.Location = new System.Drawing.Point(3, 16);
			this.thumbnailCanvas.MaximumSize = new System.Drawing.Size(2147483647, 2147483647);
			this.thumbnailCanvas.MinimumSize = new System.Drawing.Size(12, 12);
			this.thumbnailCanvas.Movable = true;
			this.thumbnailCanvas.Name = "thumbnailCanvas";
			this.thumbnailCanvas.Resizable = true;
			this.thumbnailCanvas.Size = new System.Drawing.Size(366, 69);
			this.thumbnailCanvas.TabIndex = 0;
			this.thumbnailCanvas.TextLocked = false;
			this.thumbnailCanvas.TextPlacement = System.Drawing.ContentAlignment.TopCenter;
			this.thumbnailCanvas.TextVisible = true;
			this.thumbnailCanvas.ShapeBoundsChanged += new WebTracker.ShapeEventHandler(this.thumbnailCanvas_ShapeBoundsChanged);
			this.thumbnailCanvas.SelectionChanged += new WebTracker.ShapeEventHandler(this.thumbnailCanvas_SelectionChanged);
			// 
			// splitter1
			// 
			this.splitter1.Dock = System.Windows.Forms.DockStyle.Top;
			this.splitter1.Location = new System.Drawing.Point(0, 456);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(372, 3);
			this.splitter1.TabIndex = 4;
			this.splitter1.TabStop = false;
			// 
			// PagePropertiesGroupBox
			// 
			this.PagePropertiesGroupBox.Controls.Add(this.recordHistoryCheckBox);
			this.PagePropertiesGroupBox.Controls.Add(this.pageTitleTextBox);
			this.PagePropertiesGroupBox.Controls.Add(this.label3);
			this.PagePropertiesGroupBox.Controls.Add(this.label7);
			this.PagePropertiesGroupBox.Controls.Add(this.compositeViewRadioButton);
			this.PagePropertiesGroupBox.Controls.Add(this.fullPageRadioButton);
			this.PagePropertiesGroupBox.Controls.Add(this.pollingFrequencyLabel);
			this.PagePropertiesGroupBox.Controls.Add(this.label2);
			this.PagePropertiesGroupBox.Controls.Add(this.pollingFrequency);
			this.PagePropertiesGroupBox.Controls.Add(this.label1);
			this.PagePropertiesGroupBox.Dock = System.Windows.Forms.DockStyle.Top;
			this.PagePropertiesGroupBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.PagePropertiesGroupBox.Location = new System.Drawing.Point(0, 256);
			this.PagePropertiesGroupBox.Name = "PagePropertiesGroupBox";
			this.PagePropertiesGroupBox.Size = new System.Drawing.Size(372, 200);
			this.PagePropertiesGroupBox.TabIndex = 3;
			this.PagePropertiesGroupBox.TabStop = false;
			this.PagePropertiesGroupBox.Text = "Notification Properties";
			// 
			// recordHistoryCheckBox
			// 
			this.recordHistoryCheckBox.Checked = true;
			this.recordHistoryCheckBox.CheckState = System.Windows.Forms.CheckState.Checked;
			this.recordHistoryCheckBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.recordHistoryCheckBox.Location = new System.Drawing.Point(256, 40);
			this.recordHistoryCheckBox.Name = "recordHistoryCheckBox";
			this.recordHistoryCheckBox.Size = new System.Drawing.Size(88, 24);
			this.recordHistoryCheckBox.TabIndex = 18;
			this.recordHistoryCheckBox.Text = "Record history";
			// 
			// pageTitleTextBox
			// 
			this.pageTitleTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.pageTitleTextBox.Location = new System.Drawing.Point(32, 40);
			this.pageTitleTextBox.Name = "pageTitleTextBox";
			this.pageTitleTextBox.Size = new System.Drawing.Size(208, 20);
			this.pageTitleTextBox.TabIndex = 17;
			this.pageTitleTextBox.Text = "Notification1";
			this.pageTitleTextBox.TextChanged += new System.EventHandler(this.pageTitleTextBox_TextChanged);
			// 
			// label3
			// 
			this.label3.AutoSize = true;
			this.label3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label3.Location = new System.Drawing.Point(16, 24);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(29, 16);
			this.label3.TabIndex = 16;
			this.label3.Text = "Title:";
			// 
			// label7
			// 
			this.label7.AutoSize = true;
			this.label7.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label7.Location = new System.Drawing.Point(24, 152);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(234, 16);
			this.label7.TabIndex = 15;
			this.label7.Text = "What do you want included in the notification?";
			// 
			// compositeViewRadioButton
			// 
			this.compositeViewRadioButton.Checked = true;
			this.compositeViewRadioButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.compositeViewRadioButton.Location = new System.Drawing.Point(40, 168);
			this.compositeViewRadioButton.Name = "compositeViewRadioButton";
			this.compositeViewRadioButton.Size = new System.Drawing.Size(160, 24);
			this.compositeViewRadioButton.TabIndex = 14;
			this.compositeViewRadioButton.TabStop = true;
			this.compositeViewRadioButton.Text = "Regions Marked Out Below";
			this.compositeViewRadioButton.CheckedChanged += new System.EventHandler(this.compositeViewRadioButton_CheckedChanged);
			// 
			// fullPageRadioButton
			// 
			this.fullPageRadioButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.fullPageRadioButton.Location = new System.Drawing.Point(200, 168);
			this.fullPageRadioButton.Name = "fullPageRadioButton";
			this.fullPageRadioButton.Size = new System.Drawing.Size(152, 24);
			this.fullPageRadioButton.TabIndex = 13;
			this.fullPageRadioButton.Text = "Whole Page (Thumbnail)";
			this.fullPageRadioButton.CheckedChanged += new System.EventHandler(this.fullPageRadioButton_CheckedChanged_1);
			// 
			// pollingFrequencyLabel
			// 
			this.pollingFrequencyLabel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pollingFrequencyLabel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.pollingFrequencyLabel.Location = new System.Drawing.Point(40, 120);
			this.pollingFrequencyLabel.Name = "pollingFrequencyLabel";
			this.pollingFrequencyLabel.Size = new System.Drawing.Size(304, 23);
			this.pollingFrequencyLabel.TabIndex = 12;
			this.pollingFrequencyLabel.Text = "The web site will be checked every 15 seconds.";
			// 
			// label2
			// 
			this.label2.AutoSize = true;
			this.label2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label2.Location = new System.Drawing.Point(24, 72);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(291, 16);
			this.label2.TabIndex = 11;
			this.label2.Text = "How often should the web page be checked for changes?";
			// 
			// pollingFrequency
			// 
			this.pollingFrequency.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pollingFrequency.Location = new System.Drawing.Point(32, 88);
			this.pollingFrequency.Maximum = 99;
			this.pollingFrequency.Name = "pollingFrequency";
			this.pollingFrequency.Size = new System.Drawing.Size(320, 45);
			this.pollingFrequency.TabIndex = 10;
			this.pollingFrequency.Scroll += new System.EventHandler(this.pollingFrequency_Scroll);
			// 
			// label1
			// 
			this.label1.AutoSize = true;
			this.label1.Location = new System.Drawing.Point(-68, -34);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(58, 16);
			this.label1.TabIndex = 8;
			this.label1.Text = "Page Title:";
			// 
			// propertiesGroupBox
			// 
			this.propertiesGroupBox.Controls.Add(this.changeRegionPropertiesPanel);
			this.propertiesGroupBox.Dock = System.Windows.Forms.DockStyle.Top;
			this.propertiesGroupBox.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.propertiesGroupBox.Location = new System.Drawing.Point(0, 0);
			this.propertiesGroupBox.Name = "propertiesGroupBox";
			this.propertiesGroupBox.Size = new System.Drawing.Size(372, 256);
			this.propertiesGroupBox.TabIndex = 0;
			this.propertiesGroupBox.TabStop = false;
			this.propertiesGroupBox.Text = "Region Properties";
			// 
			// changeRegionPropertiesPanel
			// 
			this.changeRegionPropertiesPanel.Controls.Add(this.landmarkComboBox);
			this.changeRegionPropertiesPanel.Controls.Add(this.label5);
			this.changeRegionPropertiesPanel.Controls.Add(this.nextShapeButton);
			this.changeRegionPropertiesPanel.Controls.Add(this.prevShapeButton);
			this.changeRegionPropertiesPanel.Controls.Add(this.thresholdLabel);
			this.changeRegionPropertiesPanel.Controls.Add(this.changeRegionSlider);
			this.changeRegionPropertiesPanel.Controls.Add(this.howMuchLabel);
			this.changeRegionPropertiesPanel.Controls.Add(this.changeRegionTextBox);
			this.changeRegionPropertiesPanel.Controls.Add(this.label4);
			this.changeRegionPropertiesPanel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.changeRegionPropertiesPanel.Location = new System.Drawing.Point(3, 16);
			this.changeRegionPropertiesPanel.Name = "changeRegionPropertiesPanel";
			this.changeRegionPropertiesPanel.Size = new System.Drawing.Size(366, 237);
			this.changeRegionPropertiesPanel.TabIndex = 2;
			// 
			// landmarkComboBox
			// 
			this.landmarkComboBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.landmarkComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.landmarkComboBox.Enabled = false;
			this.landmarkComboBox.Location = new System.Drawing.Point(80, 168);
			this.landmarkComboBox.Name = "landmarkComboBox";
			this.landmarkComboBox.Size = new System.Drawing.Size(272, 21);
			this.landmarkComboBox.TabIndex = 8;
			this.landmarkComboBox.SelectedIndexChanged += new System.EventHandler(this.landmarkComboBox_SelectedIndexChanged);
			// 
			// label5
			// 
			this.label5.AutoSize = true;
			this.label5.Enabled = false;
			this.label5.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label5.Location = new System.Drawing.Point(16, 168);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(58, 16);
			this.label5.TabIndex = 7;
			this.label5.Text = "Landmark:";
			// 
			// nextShapeButton
			// 
			this.nextShapeButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.nextShapeButton.Enabled = false;
			this.nextShapeButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.nextShapeButton.Location = new System.Drawing.Point(248, 200);
			this.nextShapeButton.Name = "nextShapeButton";
			this.nextShapeButton.Size = new System.Drawing.Size(104, 23);
			this.nextShapeButton.TabIndex = 6;
			this.nextShapeButton.Text = "Next Region >>";
			this.nextShapeButton.Click += new System.EventHandler(this.nextShapeButton_Click);
			// 
			// prevShapeButton
			// 
			this.prevShapeButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.prevShapeButton.Enabled = false;
			this.prevShapeButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.prevShapeButton.Location = new System.Drawing.Point(16, 200);
			this.prevShapeButton.Name = "prevShapeButton";
			this.prevShapeButton.Size = new System.Drawing.Size(104, 23);
			this.prevShapeButton.TabIndex = 5;
			this.prevShapeButton.Text = "<< Previous Region";
			this.prevShapeButton.Click += new System.EventHandler(this.prevShapeButton_Click);
			// 
			// thresholdLabel
			// 
			this.thresholdLabel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.thresholdLabel.Enabled = false;
			this.thresholdLabel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.thresholdLabel.Location = new System.Drawing.Point(40, 136);
			this.thresholdLabel.Name = "thresholdLabel";
			this.thresholdLabel.Size = new System.Drawing.Size(288, 24);
			this.thresholdLabel.TabIndex = 4;
			// 
			// changeRegionSlider
			// 
			this.changeRegionSlider.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.changeRegionSlider.AutoSize = false;
			this.changeRegionSlider.Enabled = false;
			this.changeRegionSlider.Location = new System.Drawing.Point(32, 96);
			this.changeRegionSlider.Maximum = 4;
			this.changeRegionSlider.Name = "changeRegionSlider";
			this.changeRegionSlider.Size = new System.Drawing.Size(312, 32);
			this.changeRegionSlider.TabIndex = 3;
			this.changeRegionSlider.Scroll += new System.EventHandler(this.changeRegionSlider_Scroll);
			// 
			// howMuchLabel
			// 
			this.howMuchLabel.Enabled = false;
			this.howMuchLabel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.howMuchLabel.Location = new System.Drawing.Point(16, 64);
			this.howMuchLabel.Name = "howMuchLabel";
			this.howMuchLabel.Size = new System.Drawing.Size(328, 32);
			this.howMuchLabel.TabIndex = 2;
			this.howMuchLabel.Text = "How much does this region have to change in order for the web page to be consider" +
				"ed updated?";
			// 
			// changeRegionTextBox
			// 
			this.changeRegionTextBox.AcceptsReturn = true;
			this.changeRegionTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.changeRegionTextBox.Enabled = false;
			this.changeRegionTextBox.Location = new System.Drawing.Point(32, 32);
			this.changeRegionTextBox.Name = "changeRegionTextBox";
			this.changeRegionTextBox.Size = new System.Drawing.Size(320, 20);
			this.changeRegionTextBox.TabIndex = 1;
			this.changeRegionTextBox.Text = "";
			this.changeRegionTextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.changeRegionTextBox_KeyPress);
			// 
			// label4
			// 
			this.label4.AutoSize = true;
			this.label4.Enabled = false;
			this.label4.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label4.Location = new System.Drawing.Point(16, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(64, 16);
			this.label4.TabIndex = 0;
			this.label4.Text = "Description:";
			// 
			// toolBar1
			// 
			this.toolBar1.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
			this.toolBar1.BackColor = System.Drawing.Color.White;
			this.toolBar1.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																																								this.arrowButton,
																																								this.drawCopyRectangle,
																																								this.drawChangeRegion,
																																								this.drawLandmark,
																																								this.toolBarButton1,
																																								this.newButton,
																																								this.openButton,
																																								this.saveButton,
																																								this.toolBarButton4,
																																								this.toolBarButton5,
																																								this.toolBarButton6,
																																								this.toolBarButton8,
																																								this.toolBarButton7,
																																								this.toolBarButton9,
																																								this.bringToFrontButton,
																																								this.sendToBackButton,
																																								this.toolBarButton2,
																																								this.trackChangesButton,
																																								this.toolBarButton3,
																																								this.inspectToolbarButton,
																																								this.testToolbarButton});
			this.toolBar1.DropDownArrows = true;
			this.toolBar1.ImageList = this.imageList1;
			this.toolBar1.Location = new System.Drawing.Point(0, 0);
			this.toolBar1.Name = "toolBar1";
			this.toolBar1.ShowToolTips = true;
			this.toolBar1.Size = new System.Drawing.Size(864, 72);
			this.toolBar1.TabIndex = 1;
			this.toolBar1.TextAlign = System.Windows.Forms.ToolBarTextAlign.Right;
			this.toolBar1.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar1_ButtonClick);
			// 
			// arrowButton
			// 
			this.arrowButton.ImageIndex = 12;
			this.arrowButton.Pushed = true;
			this.arrowButton.ToolTipText = "Select Shapes";
			// 
			// drawCopyRectangle
			// 
			this.drawCopyRectangle.ImageIndex = 11;
			this.drawCopyRectangle.Text = "Copy Region";
			this.drawCopyRectangle.ToolTipText = "Draw a new region to copy to the thumbnail view";
			// 
			// drawChangeRegion
			// 
			this.drawChangeRegion.ImageIndex = 10;
			this.drawChangeRegion.Text = "Change Region";
			this.drawChangeRegion.ToolTipText = "Draw a new region to monitor for changes";
			// 
			// drawLandmark
			// 
			this.drawLandmark.ImageIndex = 16;
			this.drawLandmark.Text = "Landmark";
			this.drawLandmark.ToolTipText = "Draw a landmark region used for image registration.";
			// 
			// toolBarButton1
			// 
			this.toolBarButton1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// newButton
			// 
			this.newButton.ImageIndex = 15;
			this.newButton.Text = "New";
			// 
			// openButton
			// 
			this.openButton.ImageIndex = 8;
			this.openButton.Text = "Open";
			this.openButton.ToolTipText = "Open a previously saved Web Page Notification Specification file";
			// 
			// saveButton
			// 
			this.saveButton.DropDownMenu = this.contextMenu1;
			this.saveButton.ImageIndex = 7;
			this.saveButton.Style = System.Windows.Forms.ToolBarButtonStyle.DropDownButton;
			this.saveButton.Text = "Save";
			this.saveButton.ToolTipText = "Save to a Web Page Notification Specification file";
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																								 this.menuItem1,
																																								 this.menuItem2});
			// 
			// menuItem1
			// 
			this.menuItem1.DefaultItem = true;
			this.menuItem1.Index = 0;
			this.menuItem1.Text = "Save";
			this.menuItem1.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "Save As...";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// toolBarButton4
			// 
			this.toolBarButton4.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			this.toolBarButton4.Visible = false;
			// 
			// toolBarButton5
			// 
			this.toolBarButton5.ImageIndex = 3;
			this.toolBarButton5.Text = "Cut";
			this.toolBarButton5.Visible = false;
			// 
			// toolBarButton6
			// 
			this.toolBarButton6.ImageIndex = 2;
			this.toolBarButton6.Text = "Copy";
			this.toolBarButton6.Visible = false;
			// 
			// toolBarButton8
			// 
			this.toolBarButton8.ImageIndex = 6;
			this.toolBarButton8.Text = "Paste";
			this.toolBarButton8.Visible = false;
			// 
			// toolBarButton7
			// 
			this.toolBarButton7.ImageIndex = 9;
			this.toolBarButton7.Text = "Undo";
			this.toolBarButton7.Visible = false;
			// 
			// toolBarButton9
			// 
			this.toolBarButton9.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// bringToFrontButton
			// 
			this.bringToFrontButton.ImageIndex = 5;
			this.bringToFrontButton.Text = "Bring To Front";
			this.bringToFrontButton.ToolTipText = "Bring To Front";
			// 
			// sendToBackButton
			// 
			this.sendToBackButton.ImageIndex = 1;
			this.sendToBackButton.Text = "Send To Back";
			this.sendToBackButton.ToolTipText = "Send To Back";
			// 
			// toolBarButton2
			// 
			this.toolBarButton2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// trackChangesButton
			// 
			this.trackChangesButton.Enabled = false;
			this.trackChangesButton.ImageIndex = 13;
			this.trackChangesButton.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.trackChangesButton.Text = "Generate";
			this.trackChangesButton.ToolTipText = "Start monitoring this web page for changes for generating notifications";
			// 
			// toolBarButton3
			// 
			this.toolBarButton3.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// inspectToolbarButton
			// 
			this.inspectToolbarButton.ImageIndex = 0;
			this.inspectToolbarButton.Text = "Connect";
			this.inspectToolbarButton.ToolTipText = "Manage the shared dictionary connection";
			// 
			// testToolbarButton
			// 
			this.testToolbarButton.ImageIndex = 14;
			this.testToolbarButton.Text = "Test Change Regions";
			this.testToolbarButton.ToolTipText = "Test the change tresholds you\'ve specified";
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "Web Page Notification Specification Files (*.xml)|*.xml|All Files (*.*)|*.*";
			this.openFileDialog1.Title = "Open Web Page Notification File";
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.Filter = "Web Page Notification Specification Files (*.xml)|*.xml|All Files (*.*)|*.*";
			this.saveFileDialog1.Title = "Save Web Page Notification File";
			// 
			// trackTimer
			// 
			this.trackTimer.Interval = 16000;
			this.trackTimer.Tick += new System.EventHandler(this.trackTimer_Tick);
			// 
			// EditorForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(864, 685);
			this.Controls.Add(this.mainLowerPanel);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.addressPanel);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "EditorForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Text = "Web Page Notification Editor - Notification1.xml";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.EditorForm_Closing);
			this.Load += new System.EventHandler(this.Form1_Load);
			this.addressPanel.ResumeLayout(false);
			this.mainLowerPanel.ResumeLayout(false);
			this.innerMainLowerPanel.ResumeLayout(false);
			this.webPageGroupBox.ResumeLayout(false);
			this.rightPanel.ResumeLayout(false);
			this.thumbnailGroupBox.ResumeLayout(false);
			this.PagePropertiesGroupBox.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.pollingFrequency)).EndInit();
			this.propertiesGroupBox.ResumeLayout(false);
			this.changeRegionPropertiesPanel.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.changeRegionSlider)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void Form1_Load(object sender, System.EventArgs e)
		{
			this.addressTextBox.Select();
		}

		void StartThread(string statusText, ThreadStart ts)
		{
			this.WaitUntilThreadFinished();
			oldCursor = Cursor.Current;
			Cursor.Current = Cursors.WaitCursor;
			lock(timerGoLock)
			{
				this.timerStatusText = statusText;
				timerGo = true;
				this.animateStatusTimer.Enabled = true;
			}
			this.theThread = new System.Threading.Thread(ts);
			this.theThread.Start();
		}

		private void EndThreadProc(object sender, EventArgs e)
		{
			this.webPageCanvas.Image = this.notification.FullPageImage;
			foreach(Shape s in this.thumbnailCanvas.Shapes)
			{
				s.Image = this.notification.FullPageImage;
			}
			goButton.Enabled = true;
			this.trackChangesButton.Enabled = true;
			this.addressTextBox.ReadOnly = false;
			this.DoneThread();
		}

		void DoneThread()
		{
			lock(timerGoLock)
			{
				Cursor.Current = oldCursor;
				this.animateStatusTimer.Enabled = false;
				timerGo = false;
				this.statusBar1.Text = "Done";
				this.theThread = null;
			}
		}

		private void goButton_Click(object sender, System.EventArgs e)
		{
			this.notification.Url = this.addressTextBox.Text;
			goButton.Enabled = false;
			this.trackChangesButton.Enabled = (string.Empty != this.notification.Url);
			this.addressTextBox.ReadOnly = true;
			this.Touch();
			this.WaitUntilThreadFinished();
			if(string.Empty != this.notification.Url)
			{
				this.StartThread(string.Format("Please wait... accessing web site {0}...", this.notification.Url), new ThreadStart(this.ThreadProc));
			}
		}

		void NewFile()
		{
			if(saveNeeded)
			{
				string msg = (fileName == DEFAULT_FILE_NAME) ?
					"You have not saved this web page notification. Do you want to save it now?" :
					"You have not saved your changes to " + System.IO.Path.GetFileName(fileName) + ". Do you want to save the file now?";
				switch(MessageBox.Show(this, msg, "Save File Before New?", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Warning))
				{
					case DialogResult.Yes:
						this.SaveFile();
						if(saveNeeded)
						{
							return;
						}
						break;
					case DialogResult.No:
						break;
					default:
						return;
				}
			}
			this.WaitUntilThreadFinished();
			this.trackTimer.Enabled = false;
			this.trackChangesButton.Enabled = false;
			this.notification.Url = string.Empty;
			this.pollingFrequency.Value = this.pollingFrequency.Minimum;
			this.webPageCanvas.BeginUpdate();
			this.thumbnailCanvas.BeginUpdate();
			this.thumbnailCanvas.Shapes.Clear();
			this.webPageCanvas.Image = null;
			this.webPageCanvas.Shapes.Clear();
			this.thumbnailCanvas.Shapes.Clear();
			this.webPageCanvas.EndUpdate();
			this.addressTextBox.Text = string.Empty;
			this.addressTextBox.Select();
			this.addressTextBox.Focus();
			this.changeRegionSlider.Enabled = false;
			this.nextShapeButton.Enabled = false;
			this.prevShapeButton.Enabled = false;
			this.changeRegionTextBox.Text = "No region selected";
			this.changeRegionSlider.Value = this.changeRegionSlider.Minimum;
			this.thresholdLabel.Text = "No region selected";
			this.changeRegionTextBox.Enabled = false;
			this.changeRegionSlider.Enabled = false;
			this.thresholdLabel.Enabled = false;
			this.label4.Enabled = false;
			this.howMuchLabel.Enabled = false;
			this.lastShapeShownInProperties = null;
			this.newCount++;
			this.notification = new WebPageNotification();
			this.fileName = DEFAULT_FILE_NAME;
			this.pageTitleTextBox.Text = this.fileName.Substring(0, this.fileName.Length - ".xml".Length);
			this.Text = string.Format("Web Page Notification Editor - {0}", System.IO.Path.GetFileName(this.fileName));
			this.saveNeeded = false;
		}

		private void toolBar1_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if(e.Button == this.arrowButton)
			{
				this.arrowButton.Pushed = true;
				this.drawChangeRegion.Pushed = false;
				this.drawCopyRectangle.Pushed = false;
				this.webPageCanvas.DrawMode = false;
			}
			else if(e.Button == this.drawChangeRegion)
			{
				this.arrowButton.Pushed = false;
				this.drawChangeRegion.Pushed = true;
				this.drawCopyRectangle.Pushed = false;
				this.webPageCanvas.DrawMode = true;
				nextRegionType = typeof(ChangeRegion);
			}
			else if(e.Button == this.drawCopyRectangle)
			{
				this.arrowButton.Pushed = false;
				this.drawChangeRegion.Pushed = false;
				this.drawCopyRectangle.Pushed = true;
				this.webPageCanvas.DrawMode = true;
				nextRegionType = typeof(CopyRegion);
			}
			else if(e.Button == this.drawLandmark)
			{
				this.arrowButton.Pushed = false;
				this.drawChangeRegion.Pushed = false;
				this.drawCopyRectangle.Pushed = true;
				this.webPageCanvas.DrawMode = true;
				nextRegionType = typeof(LandmarkRegion);
			}
			else if(e.Button == this.openButton)
			{
				this.OpenFile();
			}
			else if(e.Button == this.saveButton)
			{
				this.SaveFile();
			}
			else if(e.Button == this.newButton)
			{
				this.NewFile();
			}
			else if(e.Button == this.trackChangesButton)
			{
				this.tracking = !this.trackTimer.Enabled;
				this.trackChangesButton.Pushed = this.tracking;
				if(this.tracking)
				{
					this.generation = 0;
					this.testing = false;
					this.trackTimer_Tick(this.trackTimer, EventArgs.Empty);
				}
				this.trackTimer.Enabled = this.tracking;
			}
			else if(e.Button == this.inspectToolbarButton)
			{
				if(null == this.dictInspForm)
				{
					this.dictInspForm = DictionaryInspector.CreateDictionaryInspectorForm(this.sharedDictionary1);
					this.dictInspForm.Closed += new EventHandler(dictInspForm_Closed);
				}
				this.dictInspForm.Show();
				this.dictInspForm.BringToFront();
				this.dictInspForm.Activate();
			}
			else if(e.Button == this.testToolbarButton)
			{
				this.testing = true;
				this.trackTimer_Tick(this.trackTimer, EventArgs.Empty);
			}
			else if(e.Button == this.sendToBackButton)
			{
				this.Touch();
				foreach(Shape s in this.webPageCanvas.Shapes)
				{
					if(s.Selected)
					{
						this.notification.SendToBack(s.Tag as RegionBase);
						s.SendToBack();
						break;
					}
				}
				foreach(Shape s in this.thumbnailCanvas.Shapes)
				{
					if(s.Selected)
					{
						s.SendToBack();
						break;
					}
				}
			}
			else if(e.Button == this.bringToFrontButton)
			{
				this.Touch();
				foreach(Shape s in this.webPageCanvas.Shapes)
				{
					if(s.Selected)
					{
						this.notification.BringToFront(s.Tag as RegionBase);
						s.BringToFront();
						break;
					}
				}
				foreach(Shape s in this.thumbnailCanvas.Shapes)
				{
					if(s.Selected)
					{
						s.BringToFront();
						break;
					}
				}
			}
		}

		bool saveNeeded = false;
		int newCount = 1;
		string fileName;

		string DEFAULT_FILE_NAME
		{
			get
			{
				return string.Format("Notification{0}.xml", newCount);
			}
		}

		private bool TryOpenFile(string fn)
		{
			try
			{
				this.notification = WebPageNotification.Open(fn);
			}
			catch(Exception e)
			{
				switch(MessageBox.Show(this, "The file " + fn + " could not be opened.\r\n\r\nError details:\r\n" + e.ToString(), "Cannot Open File", MessageBoxButtons.RetryCancel))
				{
					default:
						return false;
					case DialogResult.Retry:
						if(DialogResult.OK == this.openFileDialog1.ShowDialog(this))
						{
							return this.TryOpenFile(this.openFileDialog1.FileName);
						}
						break;
				}
				return false;
			}
			this.webPageCanvas.BeginUpdate();
			this.thumbnailCanvas.BeginUpdate();
			this.webPageCanvas.Shapes.Clear();
			this.webPageCanvas.Image = this.notification.FullPageImage;
			if(string.Empty != this.notification.Url)
			{
				this.trackChangesButton.Enabled = true;
			}
			else
			{
				this.trackChangesButton.Enabled = false;
			}
			this.addressTextBox.Text = this.notification.Url;
			this.pageTitleTextBox.Text = this.notification.Title;
			this.pollingFrequency.Value = Math.Max(this.pollingFrequency.Minimum, Math.Min(this.pollingFrequency.Maximum, this.notification.UpdateInterval / 15 - 1));
			this.pollingFrequency_Scroll(this.pollingFrequency, EventArgs.Empty);
			for(int i = this.notification.ChangeRegions.Length - 1; i >= 0; i--)
			{
				this.webPageCanvas.Shapes.Add(this.NewShape(this.notification.ChangeRegions[i]));
			}
			for(int i = this.notification.CopyRegions.Length - 1; i >= 0; i--)
			{
				this.webPageCanvas.Shapes.Add(this.NewShape(this.notification.CopyRegions[i]));
			}
			for(int i = this.notification.LandmarkRegions.Length - 1; i >= 0; i--)
			{
				this.webPageCanvas.Shapes.Add(this.NewShape(this.notification.LandmarkRegions[i]));
			}
			this.thumbnailCanvas.EndUpdate();
			this.webPageCanvas.EndUpdate();
			this.fileName = fn;
			this.saveNeeded = false;
			this.Text = string.Format("Web Page Notification Editor - {0}", System.IO.Path.GetFileName(this.fileName));
			bool bb = this.webPageCanvas.Shapes.Count > 1;
			this.prevShapeButton.Enabled = bb;
			this.nextShapeButton.Enabled = bb;
			return true;
		}

		private void OpenFile()
		{
			if(saveNeeded)
			{
				string msg = (fileName == DEFAULT_FILE_NAME) ?
					"You have not saved this web page notification. Do you want to save it now?" :
					"You have not saved your changes to " + System.IO.Path.GetFileName(fileName) + ". Do you want to save the file now?";
				switch(MessageBox.Show(this, msg, "Save File Before Open?", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Warning))
				{
					case DialogResult.Yes:
						this.SaveFile();
						if(saveNeeded)
						{
							return;
						}
						break;
					case DialogResult.No:
						break;
					default:
						return;
				}
			}
			if(DialogResult.OK != this.openFileDialog1.ShowDialog(this))
			{
				return;
			}
			this.WaitUntilThreadFinished();
			this.StartThread(string.Format("Opening {0}...", this.openFileDialog1.FileName), new ThreadStart(OpenInBackgroundThread));
		}
		void OpenInBackgroundThread()
		{
			this.TryOpenFile(this.openFileDialog1.FileName);
			this.DoneThread();
		}

		private bool TrySaveFile(string fn)
		{
			try
			{
				this.notification.SaveAs(fn);
				this.fileName = fn;
				this.Text = string.Format("Web Page Notification Editor - {0}", System.IO.Path.GetFileName(this.fileName));
			}
			catch(Exception e)
			{
				if(DialogResult.Yes == MessageBox.Show(this, "There was a problem saving " + fn + "\r\n\r\nError details: " + e.ToString() + "\r\n\r\nWould you like to save to a different file name?", "Exception While Saving File", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Error))
				{
					if(DialogResult.OK == this.saveFileDialog1.ShowDialog(this))
					{
						return this.TrySaveFile(this.saveFileDialog1.FileName);
					}
				}
				return false;
			}
			return true;
		}

		private void SaveFile()
		{
			if(DEFAULT_FILE_NAME == this.fileName)
			{
				if(DialogResult.OK != this.saveFileDialog1.ShowDialog(this))
				{
					return;
				}
				this.TrySaveFile(this.saveFileDialog1.FileName);
			}
			else
			{
				this.TrySaveFile(this.fileName);
			}
		}

		private Shape NewShape(RegionBase region)
		{
			Shape e = new Shape();
			e.BorderSelect = false;
			e.TextPlacement = ContentAlignment.TopCenter;
			e.TextVisible = true;
			e.TextLocked = true;
			e.Tag = region;
			if(region is CopyRegion)
			{
				CopyRegion cr = region as CopyRegion;
				e.ForeColor = Color.FromArgb(0x80, 0xf0, 0x80);
				e.BorderStyle = System.Drawing.Drawing2D.HatchStyle.Percent70;
				cr.ThumbnailCanvasShape = new Shape();
				cr.ThumbnailCanvasShape.BorderSelect = false;
				cr.ThumbnailCanvasShape.BorderThickness = 3;
				cr.ThumbnailCanvasShape.BorderStyle = System.Drawing.Drawing2D.HatchStyle.Percent90;
				cr.ThumbnailCanvasShape.Movable = true;
				cr.ThumbnailCanvasShape.Resizable = true;
				cr.ThumbnailCanvasShape.HandleVisibility = HandleVisibility.WhenSelected;
				cr.ThumbnailCanvasShape.HandleSize = new Size(3, 3);
				cr.ThumbnailCanvasShape.ForeColor = e.ForeColor;
				cr.ThumbnailCanvasShape.Text = cr.Text;
				cr.ThumbnailCanvasShape.TextVisible = false;
				cr.ThumbnailCanvasShape.Image = this.webPageCanvas.Image;
				cr.ThumbnailCanvasShape.ImageRectangle = region.Source;
				cr.ThumbnailCanvasShape.Rectangle = cr.Destination;
				cr.ThumbnailCanvasShape.Tag = cr;
				this.thumbnailCanvas.Shapes.Add(cr.ThumbnailCanvasShape);
			}
			else if(region is ChangeRegion)
			{
				e.ForeColor = Color.FromArgb(0xf0, 0x80, 0x80);
				e.BorderStyle = System.Drawing.Drawing2D.HatchStyle.DarkDownwardDiagonal;
			}
			else if(region is LandmarkRegion)
			{
				e.ForeColor = Color.FromArgb(0x80, 0x80, 0xf0);
				e.BorderStyle = System.Drawing.Drawing2D.HatchStyle.LargeConfetti;
			}
			e.FillColor = Color.FromArgb(255 * 20 / 100, e.ForeColor);
			e.Text = region.Text;
			e.Rectangle = region.Source;
			return e;
		}

		private Shape NewShape(Type regionType)
		{
			return NewShape(this.notification.NewRegion(regionType));
		}

		private void webPageCanvas_BeginDrawing(object sender, WebTracker.ShapeEventArgs e)
		{
			this.saveNeeded = true;
			this.Text = string.Format("Web Page Notification Editor - {0}*", System.IO.Path.GetFileName(this.fileName));
			e.Shape = NewShape(this.nextRegionType);
			this.webPageCanvas.DrawMode = false;
			this.arrowButton.Pushed = true;
			this.drawChangeRegion.Pushed = false;
			this.drawCopyRectangle.Pushed = false;
		}

		private void timer1_Tick(object sender, System.EventArgs e)
		{
			lock(timerGoLock)
			{
				if(timerGo)
				{
					timerGoLevel = (1 + timerGoLevel) % timerChars.Length;
					this.statusBar1.Text = string.Format("{0}   {1}", timerChars[timerGoLevel], this.timerStatusText);
				}
			}
		}


		private void webPageCanvas_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if(e.KeyCode == Keys.Delete)
			{
				ArrayList al = new ArrayList();
				foreach(Shape s in this.webPageCanvas.Shapes)
				{
					if(s.Selected)
					{
						al.Add(s);
					}
				}
				foreach(Shape s in al)
				{
					this.webPageCanvas.Shapes.Remove(s);
					this.notification.Remove(s.Tag as RegionBase);
				}
			}
			else if((e.KeyCode == Keys.A) && e.Control)
			{
				this.webPageCanvas.SelectAll();
			}
			else if(e.KeyCode == Keys.Escape)
			{
				this.webPageCanvas.UnselectAll();
			}
		}

		private Rectangle Zoom(Rectangle r)
		{
			int ZOOM_SIZE_FACTOR_X = 1;
			int ZOOM_SIZE_FACTOR_Y = 1;
			int ZOOM_LOCATION_FACTOR_X = 4;
			int ZOOM_LOCATION_FACTOR_Y = 4;
			Size s = new Size((r.Width + ZOOM_SIZE_FACTOR_X - 1) / ZOOM_SIZE_FACTOR_X, (r.Height + ZOOM_SIZE_FACTOR_Y - 1) / ZOOM_SIZE_FACTOR_Y);
			Point p = new Point(Math.Max(0, Math.Min(r.Left / ZOOM_LOCATION_FACTOR_X, this.thumbnailCanvas.ClientSize.Width - s.Width)), Math.Max(0, Math.Min(r.Top / ZOOM_LOCATION_FACTOR_Y, this.thumbnailCanvas.ClientSize.Height - s.Height)));
			return new Rectangle(p, s);
		}

		private void webPageCanvas_EndDragShape(object sender, WebTracker.ShapeEventArgs e)
		{
			this.Touch();
			(e.Shape.Tag as RegionBase).Source = e.Shape.Rectangle;
			CopyRegion cr = e.Shape.Tag as CopyRegion;
			if((null != cr) && (null != cr.ThumbnailCanvasShape))
			{
				if(cr.Destination.IsEmpty)
				{
					cr.Destination = new Rectangle(cr.ThumbnailCanvasShape.Rectangle.Location, Zoom(e.Shape.Rectangle).Size);
					cr.ThumbnailCanvasShape.Rectangle = cr.Destination;
				}
				cr.ThumbnailCanvasShape.ImageRectangle = e.Shape.Rectangle;
			}
		}

		private void Touch()
		{
			this.notification.Touched = true;
			this.Text = string.Format("Web Page Notification Editor - {0}*", System.IO.Path.GetFileName(this.fileName));
		}

		private void webPageCanvas_ShapeRemoved(object sender, WebTracker.ShapeEventArgs e)
		{
			this.Touch();
			CopyRegion cr = e.Shape.Tag as CopyRegion;
			if((null != cr) && (null != cr.ThumbnailCanvasShape))
			{
				this.thumbnailCanvas.Shapes.Remove(cr.ThumbnailCanvasShape);
			}
			int selcount = 0;
			foreach(Shape s2 in this.webPageCanvas.Shapes)
			{
				if(s2.Selected)
				{
					selcount++;
				}
			}
			bool b = (this.webPageCanvas.Shapes.Count > 1) && (selcount <= 1);
			this.nextShapeButton.Enabled = b;
			this.prevShapeButton.Enabled = b;
		}

		private void webPageCanvas_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			int dx = 0, dy = 0;
			bool move = false;
			switch(e.KeyCode)
			{
				case Keys.Up:
					move = true;
					dy = -GRID_SIZE_Y;
					break;
				case Keys.Down:
					move = true;
					dy = GRID_SIZE_Y;
					break;
				case Keys.Left:
					move = true;
					dx = -GRID_SIZE_X;
					break;
				case Keys.Right:
					move = true;
					dx = GRID_SIZE_X;
					break;
			}
			if(move)
			{
				foreach(Shape s in (sender as Canvas).Shapes)
				{
					if(s.Selected)
					{
						s.Rectangle = new Rectangle(s.Rectangle.Left + dx, s.Rectangle.Top + dy, s.Rectangle.Width, s.Rectangle.Height);
						(s.Tag as RegionBase).Source = s.Rectangle;
					}
				}
			}
		}

		private void webPageCanvas_ShapeAdded(object sender, WebTracker.ShapeEventArgs e)
		{
			this.saveNeeded = true;
			this.Text = string.Format("Web Page Notification Editor - {0}*", System.IO.Path.GetFileName(this.fileName));
			// MEMO: there was a bit of code here for adding the ThumbnailCanvasShape to the thumbnailCanvas, but it should no longer be here
			int selcount = 0;
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				if(s.Selected)
				{
					selcount++;
				}
			}
			bool b = (this.webPageCanvas.Shapes.Count > 1) && (selcount <= 1);
			this.nextShapeButton.Enabled = b;
			this.prevShapeButton.Enabled = b;			
		}

		void WaitUntilThreadFinished()
		{
			Thread t = null;
			lock(this.timerGoLock)
			{
				t = this.theThread;
			}
			if(null != t)
			{
				t.Join();
			}
		}

		private void EditorForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			this.WaitUntilThreadFinished();
			if(null != this.dictInspForm)
			{
				this.dictInspForm.Close();
			}
		}

		void ThreadProc()
		{
			this.Touch();
			this.notification.Update();
			if(this.pageTitleTextBox.Text != this.notification.Title)
			{
				this.pageTitleTextBox.Text = this.notification.Title;
			}
			this.notification.Log();
			this.webPageCanvas.BeginUpdate();
			this.webPageCanvas.Image = this.notification.FullPageImage;
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				s.Rectangle = (s.Tag as RegionBase).Source;
			}
			this.webPageCanvas.EndUpdate();
			this.thumbnailCanvas.BeginUpdate();
			for(int i = 0; i < this.notification.CopyRegions.Length; i++)
			{
				this.notification.CopyRegions[i].ThumbnailCanvasShape.Image = this.notification.FullPageImage;
				this.notification.CopyRegions[i].ThumbnailCanvasShape.Rectangle = this.notification.CopyRegions[i].Destination;
				this.notification.CopyRegions[i].ThumbnailCanvasShape.ImageRectangle = this.notification.CopyRegions[i].Source;
			}
			this.thumbnailCanvas.EndUpdate();
			bool changed = false;
			StringBuilder b = new StringBuilder();
			b.Append("Done. ");
			if(this.testing || this.tracking)
			{
				for(int i = 0; i < this.notification.ChangeRegions.Length; i++)
				{
					changed = changed || this.notification.ChangeRegions[i].Changed;
					if(i > 0)
					{
						b.Append(", ");
					}
					b.Append(string.Format("{0}: {1}", this.notification.ChangeRegions[i].Text, this.GetThresholdAdjective(this.notification.ChangeRegions[i].PSNR)));
				}
			}
			else
			{
				this.DoneThread();
				this.statusBar1.Text = b.ToString();
				return;
			}
			if(this.testing)
			{
				this.testing = false;
				this.DoneThread();
				using(TestResultsForm f = new TestResultsForm(this.notification))
				{
					f.ShowDialog();
				}
				return;
			}
			this.generation++;
			// TODO: Insert logging code here...
			if(!changed && (generation > 1))
			{
				this.DoneThread();
				this.statusBar1.Text = b.ToString();
				return;
			}
			Map thumbnailMap = this.GetMap(this.fullPageRadioButton.Checked);
			this.sharedDictionary1.SuspendNotifications();
			this.sharedDictionary1[this.root + "/title"] = this.pageTitleTextBox.Text;
			this.sharedDictionary1[this.root + "/url"] = this.notification.Url;
			if(this.sharedDictionary1.Contains(this.root + "/thumbnails"))
			{
				SharedDictionary.Vector v = (SharedDictionary.Vector) this.sharedDictionary1[this.root + "/thumbnails"];
				if(this.recordHistoryCheckBox.Checked)
				{
					const int MAX_HISTORY_LENGTH = 200;
					string p = this.root + "/thumbnails#0";
					for(int i = v.Count - MAX_HISTORY_LENGTH - 1; i >= 0; i--)
					{
						this.sharedDictionary1.Remove(p);
					}
				}
				else
				{
					string p = this.root + "/thumbnails#1";
					for(int i = v.Count - 1; i >= 1; i--)
					{
						this.sharedDictionary1.Remove(p);
					}
				}
			}
			if(this.recordHistoryCheckBox.Checked)
			{
				this.sharedDictionary1[this.root + "/thumbnails#-0"] = thumbnailMap;
			}
			else
			{
				this.sharedDictionary1[this.root + "/thumbnails#0"] = thumbnailMap;
			}
			this.sharedDictionary1[this.root] = "Web Page Notification";
			this.sharedDictionary1.ResumeNotifications();
			this.DoneThread();
			this.statusBar1.Text = b.ToString();
		}

		private void trackTimer_Tick(object sender, System.EventArgs e)
		{
			this.WaitUntilThreadFinished();
			this.StartThread("Checking web site for changes...", new ThreadStart(this.ThreadProc));
		}

		private void dictInspForm_Closed(object sender, EventArgs e)
		{
			this.dictInspForm = null;
		}

		Shape lastShapeShownInProperties = null;

		private void webPageCanvas_SelectionChanged(object sender, WebTracker.ShapeEventArgs e)
		{
			CopyRegion cr = e.Shape.Tag as CopyRegion;
			if((null != cr) && (null != cr.ThumbnailCanvasShape))
			{
				cr.ThumbnailCanvasShape.Selected = e.Shape.Selected;
			}
			landmarkComboBox.Items.Clear();
			landmarkComboBox.Items.Add("(none)");
			for(int i = 0; i < this.notification.LandmarkRegions.Length; i++)
			{
				landmarkComboBox.Items.Add(this.notification.LandmarkRegions[i].Text);
			}
			if(this.notification.LandmarkRegions.Length > 0)
			{
				this.landmarkComboBox.Enabled = true;
			}
			else
			{
				this.landmarkComboBox.Enabled = false;
			}
			int selcount = 0;
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				if(s.Selected)
				{
					selcount++;
				}
			}
			bool b = (this.webPageCanvas.Shapes.Count > 1) && (selcount <= 1);
			this.nextShapeButton.Enabled = b;
			this.prevShapeButton.Enabled = b;
			if(object.ReferenceEquals(e.Shape, this.lastShapeShownInProperties))
			{
				e.Shape.Text = this.changeRegionTextBox.Text;
				this.saveNeeded = true;
				this.Text = string.Format("Web Page Notification Editor - {0}*", System.IO.Path.GetFileName(this.fileName));
			}
			int copyCount = 0, changeCount = 0, landmarkCount = 0;
			Shape selshape = null;
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				if(s.Selected)
				{
					selshape = s;
					if(s.Tag is CopyRegion)
					{
						copyCount++;
					}
					else if(s.Tag is ChangeRegion)
					{
						changeCount++;
					}
					else if(s.Tag is LandmarkRegion)
					{
						landmarkCount++;
					}
				}
			}
			if((copyCount + changeCount + landmarkCount) == 1)
			{
				this.changeRegionTextBox.Enabled = true;
				this.label4.Enabled = false;
				this.howMuchLabel.Enabled = false;
				if(copyCount == 1)
				{
					this.changeRegionTextBox.Text = selshape.Text;
					this.changeRegionSlider.Enabled = false;
					this.howMuchLabel.Enabled = false;
					this.thresholdLabel.Enabled = false;
					this.thresholdLabel.Text = "Selected region is a copy region, not a change region.";
					this.thumbnailCanvas.ScrollIntoView((selshape.Tag as CopyRegion).ThumbnailCanvasShape);
					this.landmarkComboBox.Text = (selshape.Tag as LandmarkRelativeRegionBase).SafeLandmarkName;
				}
				else if(changeCount == 1)
				{
					this.changeRegionTextBox.Text = selshape.Text;
					this.changeRegionSlider.Enabled = true;
					this.howMuchLabel.Enabled = true;
					this.thresholdLabel.Enabled = true;
					this.thresholdLabel.Text = this.GetThresholdDescription(this.changeRegionSlider.Value);
					this.changeRegionSlider.Value = Math.Max(this.changeRegionSlider.Minimum, Math.Min(this.changeRegionSlider.Maximum,  this.GetThresholdIndex((selshape.Tag as ChangeRegion).Threshold)));
					this.landmarkComboBox.Text = (selshape.Tag as LandmarkRelativeRegionBase).SafeLandmarkName;
				}
				else if(landmarkCount == 1)
				{
					this.changeRegionTextBox.Text = selshape.Text;
					this.changeRegionSlider.Enabled = false;
					this.howMuchLabel.Enabled = false;
					this.thresholdLabel.Enabled = false;
					this.thresholdLabel.Text = "Selected region is a landmark region, not a change region.";
					this.landmarkComboBox.Text = "(none)";
					this.landmarkComboBox.Enabled = false;
				}
				this.lastShapeShownInProperties = selshape;
			}
			else
			{
				this.changeRegionTextBox.Text = "No region selected";
				this.changeRegionSlider.Value = this.changeRegionSlider.Minimum;
				this.thresholdLabel.Text = "No region selected";
				this.changeRegionTextBox.Enabled = false;
				this.changeRegionSlider.Enabled = false;
				this.thresholdLabel.Enabled = false;
				this.label4.Enabled = false;
				this.howMuchLabel.Enabled = false;
				this.lastShapeShownInProperties = null;
				this.landmarkComboBox.Text = "(none)";
				this.landmarkComboBox.Enabled = false;
			}
		}

		public Map GetMap(bool fullPageThumbnail)
		{
			Map map = new Map();
			map["timestamp"] = DateTime.Now;
			Image thumbnailImage;
			if(fullPageThumbnail)
			{
				thumbnailImage = this.notification.FullPageThumbnail;
			}
			else
			{
				thumbnailImage = this.notification.CompositeImage;
			}
			map["image"] = UrlGrabber.ToPng(thumbnailImage as Bitmap);
			return map;
		}

		private string GetThresholdAdjective(double psnr)
		{
			if(double.IsInfinity(psnr))
			{
				return "No differences";
			}
			else
			{
				string[] adjs = new string[]{"Negligable differences", "Some differences", "Considerable differences", "Substantial differences", "Entirely different"};
				for(int i = 1; i >= 4; i++)
				{
					if(psnr > GetThresholdValue(i))
					{
						return adjs[i - 1];
					}
				}
				return adjs[adjs.Length - 1];
			}
		}
		private string GetThresholdDescription(int index)
		{
			switch(index)
			{
				default:
					return "The web site will be considered changed when this region changes at all."; 
				case 1:
					return "The web site will be considered changed when this region changes at least somewhat.";
				case 2:
					return "The web site will be considered changed when this region changes considerably.";
				case 3:
					return "The web site will be considered changed when this region changes a lot.";
				case 4:
					return "The web site will be considered changed when this region changes almost entirely.";
			}

		}

		private double GetThresholdValue(int index)
		{
			switch(index)
			{
				default:
					return 0;
				case 1:
					return -10;
				case 2:
					return -20;
				case 3:
					return -30;
				case 4:
					return -40;
			}
		}

		private int GetThresholdIndex(double value)
		{
			for(int i = 1; i <= 4; i++)
			{
				if(value > GetThresholdValue(i))
				{
					return i - 1;
				}
			}
			return 4;
		}

		private void changeRegionSlider_Scroll(object sender, System.EventArgs e)
		{
			this.thresholdLabel.Text = this.GetThresholdDescription(this.changeRegionSlider.Value);
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				if(s.Selected)
				{
					this.Touch();
					ChangeRegion cr = (s.Tag as ChangeRegion);
					if(null != cr)
					{
						cr.Threshold = this.GetThresholdValue(changeRegionSlider.Value);
					}
					break;
				}
			}
		}

		private void pollingFrequency_Scroll(object sender, System.EventArgs e)
		{
			this.Touch();
			int seconds = PollingFrequencies[this.pollingFrequency.Value];
			this.trackTimer.Interval = 1000 * seconds;
			if(seconds <= 90)
			{
				this.pollingFrequencyLabel.Text = string.Format("The web site will be checked every {0} seconds.", seconds);
			}
			else if(seconds <= 60 * 60)
			{
				this.pollingFrequencyLabel.Text = string.Format("The web site will be checked every {0:0.0} minutes.", seconds / 60.0);
			}
			else if(seconds <= (60 * 60 * 36))
			{
				this.pollingFrequencyLabel.Text = string.Format("The web site will be checked every {0:0.0} hours.", seconds / 3600.0);
			}
			else
			{
				this.pollingFrequencyLabel.Text = string.Format("The web site will be checked every {0:0.0} days.", seconds / (60.0 * 60.0 * 24.0));
			}
		}

		private void compositeViewRadioButton_CheckedChanged(object sender, System.EventArgs e)
		{
			this.Touch();
			this.notification.ShowFullPageThumbnail = this.fullPageRadioButton.Checked;
			this.thumbnailCanvas.Enabled = !this.notification.ShowFullPageThumbnail;
		}

		private void fullPageRadioButton_CheckedChanged_1(object sender, System.EventArgs e)
		{
			this.Touch();
			this.notification.ShowFullPageThumbnail = this.fullPageRadioButton.Checked;
			this.thumbnailCanvas.Enabled = !this.notification.ShowFullPageThumbnail;
		}


		private void changeRegionTextBox_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if(e.KeyChar == '\r')
			{
				foreach(Shape s in this.webPageCanvas.Shapes)
				{
					if(s.Selected)
					{
						s.Text = (sender as TextBox).Text;
						(s.Tag as RegionBase).Text = s.Text;
						this.Touch();
						break;
					}
				}		
			}
		}

		private void Test()
		{
			lock(this.timerGoLock)
			{
				this.timerGo = true;
				this.timerGoLevel = 0;
				this.timerStatusText = "Testing ... this may take up to a minute...";
				this.animateStatusTimer.Enabled = true;
			}
			// TODO: change the way testing works
		}

		private void addressTextBox_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if(e.KeyChar == '\r')
			{
				this.goButton_Click(this.goButton, EventArgs.Empty);
			}
		}

		private void prevShapeButton_Click(object sender, System.EventArgs e)
		{
			int i;
			for(i = 0; i  < this.webPageCanvas.Shapes.Count; i++)
			{
				if(this.webPageCanvas.Shapes[i].Selected)
				{
					break;
				}
			}
			i = Math.Max(0, Math.Min(i, this.webPageCanvas.Shapes.Count - 1));
			this.webPageCanvas.Shapes[i].Selected = false;
			this.webPageCanvas.Shapes[(i + this.webPageCanvas.Shapes.Count - 1) % this.webPageCanvas.Shapes.Count].Selected = true;
		}

		private void nextShapeButton_Click(object sender, System.EventArgs e)
		{
			int i;
			for(i = 0; i  < this.webPageCanvas.Shapes.Count; i++)
			{
				if(this.webPageCanvas.Shapes[i].Selected)
				{
					break;
				}
			}
			i = Math.Max(0, Math.Min(i, this.webPageCanvas.Shapes.Count - 1));
			this.webPageCanvas.Shapes[i].Selected = false;
			this.webPageCanvas.Shapes[(i + 1) % this.webPageCanvas.Shapes.Count].Selected = true;
		}

		private void thumbnailCanvas_SelectionChanged(object sender, WebTracker.ShapeEventArgs e)
		{
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				CopyRegion cr = s.Tag as CopyRegion;
				if((null != cr) && (cr.ThumbnailCanvasShape == e.Shape))
				{
					s.Selected = e.Shape.Selected;
					if(s.Selected)
					{
						this.webPageCanvas.ScrollIntoView(s);
					}
				}
			}
		}

		private void pageTitleTextBox_TextChanged(object sender, System.EventArgs e)
		{
			this.notification.Title = this.pageTitleTextBox.Text;
			this.Touch();
		}

		private void menuItem1_Click(object sender, System.EventArgs e)
		{
			this.SaveFile();
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialog1.FileName = this.fileName;
			if(DialogResult.OK != this.saveFileDialog1.ShowDialog(this))
			{
				return;
			}
			this.TrySaveFile(this.saveFileDialog1.FileName);		
		}

		private void landmarkComboBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			foreach(Shape s in this.webPageCanvas.Shapes)
			{
				LandmarkRelativeRegionBase region = s.Tag as LandmarkRelativeRegionBase;
				if(s.Selected && (null != region))
				{
					if(landmarkComboBox.SelectedIndex <= 0)
					{
						region.LandmarkName = string.Empty;
					}
					else
					{
						region.LandmarkName = landmarkComboBox.Items[landmarkComboBox.SelectedIndex].ToString();
					}
				}
			}
		}

		private void thumbnailCanvas_ShapeBoundsChanged(object sender, WebTracker.ShapeEventArgs e)
		{
			(e.Shape.Tag as CopyRegion).Destination = e.Shape.Rectangle;
		}
	}
}
